/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import com.rabbitmq.client.LongString;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.rabbitmq.RabbitMQMessage;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class IncomingRabbitMQMetadata {
    private final RabbitMQMessage message;
    private final Map<String, Object> headers;

    IncomingRabbitMQMetadata(RabbitMQMessage message) {
        this.message = message;
        Map incomingHeaders = message.properties().getHeaders();
        this.headers = incomingHeaders != null ? (Map)incomingHeaders.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), IncomingRabbitMQMetadata.mapValue(e.getValue())), HashMap::putAll) : new HashMap<String, Object>();
    }

    private static Object mapValue(Object v) {
        if (v instanceof LongString) {
            return v.toString();
        }
        if (v instanceof List) {
            return ((List)v).stream().map(IncomingRabbitMQMetadata::mapValue).collect(Collectors.toList());
        }
        return v;
    }

    public <T> @Nullable Optional<T> getHeader(String header, Class<T> type) {
        Object value = this.headers.get(header);
        if (value == null) {
            return Optional.empty();
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type specified for header '" + header + "'. Expected [" + String.valueOf(type) + "] but actual type is [" + String.valueOf(value.getClass()) + "]");
        }
        return Optional.of(value);
    }

    public Map<String, Object> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Optional<String> getContentType() {
        return Optional.ofNullable(this.message.properties().getContentType());
    }

    public Optional<String> getContentEncoding() {
        return Optional.ofNullable(this.message.properties().getContentEncoding());
    }

    public Optional<Integer> getDeliveryMode() {
        return Optional.ofNullable(this.message.properties().getDeliveryMode());
    }

    public Optional<Integer> getPriority() {
        return Optional.ofNullable(this.message.properties().getPriority());
    }

    public Optional<String> getCorrelationId() {
        return Optional.ofNullable(this.message.properties().getCorrelationId());
    }

    public Optional<String> getReplyTo() {
        return Optional.ofNullable(this.message.properties().getReplyTo());
    }

    public Optional<String> getExpiration() {
        return Optional.ofNullable(this.message.properties().getExpiration());
    }

    public Optional<String> getMessageId() {
        return Optional.ofNullable(this.message.properties().getMessageId());
    }

    public Optional<ZonedDateTime> getTimestamp(ZoneId zoneId) {
        Optional<Date> timestamp = Optional.ofNullable(this.message.properties().getTimestamp());
        return timestamp.map(t -> ZonedDateTime.ofInstant(t.toInstant(), zoneId));
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.message.properties().getType());
    }

    public Optional<String> getUserId() {
        return Optional.ofNullable(this.message.properties().getUserId());
    }

    public Optional<String> getAppId() {
        return Optional.ofNullable(this.message.properties().getAppId());
    }

    @Deprecated
    public Optional<ZonedDateTime> getCreationTime(ZoneId zoneId) {
        Optional<Date> timestamp = Optional.ofNullable(this.message.properties().getTimestamp());
        return timestamp.map(t -> ZonedDateTime.ofInstant(t.toInstant(), zoneId));
    }

    @Deprecated
    public Optional<String> getId() {
        return Optional.ofNullable(this.message.properties().getMessageId());
    }

    public String getExchange() {
        return this.message.envelope().getExchange();
    }

    public String getRoutingKey() {
        return this.message.envelope().getRoutingKey();
    }

    public boolean isRedeliver() {
        return this.message.envelope().isRedeliver();
    }
}

