/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import com.rabbitmq.client.BasicProperties;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.LongString;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.rabbitmq.RabbitMQMessage;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class IncomingRabbitMQMetadata {
    private final Map<String, Object> headers;
    private final BasicProperties properties;
    private final Envelope envelope;

    IncomingRabbitMQMetadata(RabbitMQMessage message) {
        this(message.properties(), message.envelope());
    }

    IncomingRabbitMQMetadata(BasicProperties properties, Envelope envelope) {
        this.properties = properties;
        this.envelope = envelope;
        Map incomingHeaders = properties.getHeaders();
        this.headers = incomingHeaders != null ? (Map)incomingHeaders.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), IncomingRabbitMQMetadata.mapValue(e.getValue())), HashMap::putAll) : new HashMap<String, Object>();
    }

    private static Object mapValue(Object v) {
        if (v instanceof LongString) {
            return v.toString();
        }
        if (v instanceof List) {
            return ((List)v).stream().map(IncomingRabbitMQMetadata::mapValue).collect(Collectors.toList());
        }
        return v;
    }

    public <T> @Nullable Optional<T> getHeader(String header, Class<T> type) {
        Object value = this.headers.get(header);
        if (value == null) {
            return Optional.empty();
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type specified for header '" + header + "'. Expected [" + String.valueOf(type) + "] but actual type is [" + String.valueOf(value.getClass()) + "]");
        }
        return Optional.of(value);
    }

    public Map<String, Object> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Optional<String> getContentType() {
        return Optional.ofNullable(this.properties.getContentType());
    }

    public Optional<String> getContentEncoding() {
        return Optional.ofNullable(this.properties.getContentEncoding());
    }

    public Optional<Integer> getDeliveryMode() {
        return Optional.ofNullable(this.properties.getDeliveryMode());
    }

    public Optional<Integer> getPriority() {
        return Optional.ofNullable(this.properties.getPriority());
    }

    public Optional<String> getCorrelationId() {
        return Optional.ofNullable(this.properties.getCorrelationId());
    }

    public Optional<String> getReplyTo() {
        return Optional.ofNullable(this.properties.getReplyTo());
    }

    public Optional<String> getExpiration() {
        return Optional.ofNullable(this.properties.getExpiration());
    }

    public Optional<String> getMessageId() {
        return Optional.ofNullable(this.properties.getMessageId());
    }

    public Optional<ZonedDateTime> getTimestamp(ZoneId zoneId) {
        Optional<Date> timestamp = Optional.ofNullable(this.properties.getTimestamp());
        return timestamp.map(t -> ZonedDateTime.ofInstant(t.toInstant(), zoneId));
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.properties.getType());
    }

    public Optional<String> getUserId() {
        return Optional.ofNullable(this.properties.getUserId());
    }

    public Optional<String> getAppId() {
        return Optional.ofNullable(this.properties.getAppId());
    }

    @Deprecated
    public Optional<ZonedDateTime> getCreationTime(ZoneId zoneId) {
        Optional<Date> timestamp = Optional.ofNullable(this.properties.getTimestamp());
        return timestamp.map(t -> ZonedDateTime.ofInstant(t.toInstant(), zoneId));
    }

    @Deprecated
    public Optional<String> getId() {
        return Optional.ofNullable(this.properties.getMessageId());
    }

    public String getExchange() {
        return this.envelope.getExchange();
    }

    public String getRoutingKey() {
        return this.envelope.getRoutingKey();
    }

    public boolean isRedeliver() {
        return this.envelope.isRedeliver();
    }
}

