/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.smallrye.reactive.messaging.rabbitmq.tracing.RabbitMQTrace;
import io.smallrye.reactive.messaging.rabbitmq.tracing.RabbitMQTraceAttributesExtractor;
import io.smallrye.reactive.messaging.rabbitmq.tracing.RabbitMQTraceTextMapGetter;
import io.smallrye.reactive.messaging.rabbitmq.tracing.RabbitMQTraceTextMapSetter;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import jakarta.enterprise.inject.Instance;
import org.eclipse.microprofile.reactive.messaging.Message;

public class RabbitMQOpenTelemetryInstrumenter {
    private final Instrumenter<RabbitMQTrace, Void> instrumenter;

    protected RabbitMQOpenTelemetryInstrumenter(Instrumenter<RabbitMQTrace, Void> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public static RabbitMQOpenTelemetryInstrumenter createForSender(Instance<OpenTelemetry> openTelemetryInstance) {
        return RabbitMQOpenTelemetryInstrumenter.create(TracingUtils.getOpenTelemetry(openTelemetryInstance), true);
    }

    public static RabbitMQOpenTelemetryInstrumenter createForConnector(Instance<OpenTelemetry> openTelemetryInstance) {
        return RabbitMQOpenTelemetryInstrumenter.create(TracingUtils.getOpenTelemetry(openTelemetryInstance), false);
    }

    private static RabbitMQOpenTelemetryInstrumenter create(OpenTelemetry openTelemetry, boolean sender) {
        MessageOperation messageOperation = sender ? MessageOperation.PUBLISH : MessageOperation.RECEIVE;
        RabbitMQTraceAttributesExtractor rabbitMQAttributesExtractor = new RabbitMQTraceAttributesExtractor();
        MessagingAttributesGetter<RabbitMQTrace, Void> messagingAttributesGetter = rabbitMQAttributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.smallrye.reactive.messaging", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation));
        builder.addAttributesExtractor((AttributesExtractor)rabbitMQAttributesExtractor).addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation));
        Instrumenter instrumenter = sender ? builder.buildProducerInstrumenter((TextMapSetter)RabbitMQTraceTextMapSetter.INSTANCE) : builder.buildConsumerInstrumenter((TextMapGetter)RabbitMQTraceTextMapGetter.INSTANCE);
        return new RabbitMQOpenTelemetryInstrumenter((Instrumenter<RabbitMQTrace, Void>)instrumenter);
    }

    public void traceOutgoing(Message<?> message, RabbitMQTrace trace) {
        TracingUtils.traceOutgoing(this.instrumenter, message, (Object)trace);
    }

    public Message<?> traceIncoming(Message<?> msg, RabbitMQTrace trace) {
        return TracingUtils.traceIncoming(this.instrumenter, msg, (Object)trace);
    }
}

