/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq.tracing;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.smallrye.reactive.messaging.rabbitmq.IncomingRabbitMQMessage;
import io.smallrye.reactive.messaging.rabbitmq.tracing.RabbitMQTrace;
import io.smallrye.reactive.messaging.rabbitmq.tracing.RabbitMQTraceAttributesExtractor;
import io.smallrye.reactive.messaging.rabbitmq.tracing.RabbitMQTraceTextMapGetter;
import io.smallrye.reactive.messaging.rabbitmq.tracing.RabbitMQTraceTextMapSetter;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import org.eclipse.microprofile.reactive.messaging.Message;

public class RabbitMQOpenTelemetryInstrumenter {
    private final Instrumenter<RabbitMQTrace, Void> instrumenter;

    protected RabbitMQOpenTelemetryInstrumenter(Instrumenter<RabbitMQTrace, Void> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public static RabbitMQOpenTelemetryInstrumenter createForSender() {
        return RabbitMQOpenTelemetryInstrumenter.create(true);
    }

    public static RabbitMQOpenTelemetryInstrumenter createForConnector() {
        return RabbitMQOpenTelemetryInstrumenter.create(false);
    }

    private static RabbitMQOpenTelemetryInstrumenter create(boolean sender) {
        MessageOperation messageOperation = sender ? MessageOperation.SEND : MessageOperation.RECEIVE;
        RabbitMQTraceAttributesExtractor rabbitMQAttributesExtractor = new RabbitMQTraceAttributesExtractor();
        MessagingAttributesGetter<RabbitMQTrace, Void> messagingAttributesGetter = rabbitMQAttributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)"io.smallrye.reactive.messaging", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation));
        builder.addAttributesExtractor((AttributesExtractor)rabbitMQAttributesExtractor).addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation));
        Instrumenter instrumenter = sender ? builder.buildProducerInstrumenter((TextMapSetter)RabbitMQTraceTextMapSetter.INSTANCE) : builder.buildConsumerInstrumenter((TextMapGetter)RabbitMQTraceTextMapGetter.INSTANCE);
        return new RabbitMQOpenTelemetryInstrumenter((Instrumenter<RabbitMQTrace, Void>)instrumenter);
    }

    public void traceOutgoing(Message<?> message, RabbitMQTrace trace) {
        TracingUtils.traceOutgoing(this.instrumenter, message, (Object)trace);
    }

    public void traceIncoming(IncomingRabbitMQMessage<Object> msg, RabbitMQTrace trace) {
        TracingUtils.traceIncoming(this.instrumenter, msg, (Object)trace);
    }
}

