/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.smallrye.reactive.messaging.providers.MetadataInjectableMessage;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.smallrye.reactive.messaging.rabbitmq.ConnectionHolder;
import io.smallrye.reactive.messaging.rabbitmq.IncomingRabbitMQMetadata;
import io.smallrye.reactive.messaging.rabbitmq.ack.RabbitMQAckHandler;
import io.smallrye.reactive.messaging.rabbitmq.fault.RabbitMQFailureHandler;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQLogging;
import io.vertx.core.buffer.Buffer;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.rabbitmq.RabbitMQMessage;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class IncomingRabbitMQMessage<T>
implements ContextAwareMessage<T>,
MetadataInjectableMessage<T> {
    protected final io.vertx.rabbitmq.RabbitMQMessage message;
    protected Metadata metadata;
    protected final IncomingRabbitMQMetadata rabbitMQMetadata;
    private final ConnectionHolder holder;
    private final Context context;
    private final long deliveryTag;
    private RabbitMQFailureHandler onNack;
    private RabbitMQAckHandler onAck;
    private final String contentTypeOverride;
    private final T payload;

    IncomingRabbitMQMessage(RabbitMQMessage delegate, ConnectionHolder holder, RabbitMQFailureHandler onNack, RabbitMQAckHandler onAck, String contentTypeOverride) {
        this(delegate.getDelegate(), holder, onNack, onAck, contentTypeOverride);
    }

    IncomingRabbitMQMessage(io.vertx.rabbitmq.RabbitMQMessage msg, ConnectionHolder holder, RabbitMQFailureHandler onNack, RabbitMQAckHandler onAck, String contentTypeOverride) {
        this.message = msg;
        this.deliveryTag = msg.envelope().getDeliveryTag();
        this.holder = holder;
        this.context = holder.getContext();
        this.contentTypeOverride = contentTypeOverride;
        this.rabbitMQMetadata = new IncomingRabbitMQMetadata(this.message);
        this.onNack = onNack;
        this.onAck = onAck;
        this.metadata = ContextAwareMessage.captureContextMetadata((Object[])new Object[]{this.rabbitMQMetadata});
        this.payload = this.convertPayload(this.message);
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return arg_0 -> ((IncomingRabbitMQMessage)this).nack(arg_0);
    }

    public CompletionStage<Void> ack() {
        try {
            CompletionStage<Void> completionStage = this.onAck.handle(this, this.context);
            return completionStage;
        }
        finally {
            this.onAck = AlreadyAcknowledgedHandler.INSTANCE;
            this.onNack = AlreadyAcknowledgedHandler.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        try {
            CompletionStage<Void> completionStage = this.onNack.handle(this, this.context, reason);
            return completionStage;
        }
        finally {
            this.onAck = AlreadyAcknowledgedHandler.INSTANCE;
            this.onNack = AlreadyAcknowledgedHandler.INSTANCE;
        }
    }

    public void acknowledgeMessage() {
        this.holder.getAck(this.deliveryTag).subscribeAsCompletionStage();
    }

    public void rejectMessage(Throwable reason) {
        this.holder.getNack(this.deliveryTag, false).apply(reason);
    }

    public T getPayload() {
        return this.payload;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private Object convertPayload(io.vertx.rabbitmq.RabbitMQMessage msg) {
        String contentType = msg.properties().getContentType();
        String contentEncoding = msg.properties().getContentEncoding();
        Buffer body = msg.body();
        if (this.contentTypeOverride != null) {
            contentType = this.contentTypeOverride;
        }
        if (contentEncoding == null) {
            try {
                if (HttpHeaderValues.APPLICATION_JSON.toString().equalsIgnoreCase(contentType)) {
                    return body.toJson();
                }
                if (HttpHeaderValues.TEXT_PLAIN.toString().equalsIgnoreCase(contentType)) {
                    return body.toString();
                }
            }
            catch (Throwable t) {
                RabbitMQLogging.log.typeConversionFallback();
            }
        } else if (!HttpHeaderValues.APPLICATION_OCTET_STREAM.toString().equalsIgnoreCase(contentType)) {
            RabbitMQLogging.log.typeConversionFallback();
        }
        return body.getBytes();
    }

    public Map<String, Object> getHeaders() {
        return this.rabbitMQMetadata.getHeaders();
    }

    public Optional<String> getContentType() {
        return this.rabbitMQMetadata.getContentType();
    }

    public Optional<String> getContentEncoding() {
        return this.rabbitMQMetadata.getContentEncoding();
    }

    public Optional<Integer> getDeliveryMode() {
        return this.rabbitMQMetadata.getDeliveryMode();
    }

    public Optional<Integer> getPriority() {
        return this.rabbitMQMetadata.getPriority();
    }

    public Optional<String> getCorrelationId() {
        return this.rabbitMQMetadata.getCorrelationId();
    }

    public Optional<String> getReplyTo() {
        return this.rabbitMQMetadata.getReplyTo();
    }

    public Optional<String> getExpiration() {
        return this.rabbitMQMetadata.getExpiration();
    }

    public Optional<String> getMessageId() {
        return this.rabbitMQMetadata.getMessageId();
    }

    public Optional<ZonedDateTime> getTimestamp(ZoneId zoneId) {
        return this.rabbitMQMetadata.getTimestamp(zoneId);
    }

    public Optional<String> getType() {
        return this.rabbitMQMetadata.getType();
    }

    public Optional<String> getUserId() {
        return this.rabbitMQMetadata.getUserId();
    }

    public Optional<String> getAppId() {
        return this.rabbitMQMetadata.getAppId();
    }

    @Deprecated
    public Optional<ZonedDateTime> getCreationTime(ZoneId zoneId) {
        return this.rabbitMQMetadata.getTimestamp(zoneId);
    }

    public RabbitMQMessage getRabbitMQMessage() {
        return new RabbitMQMessage(this.message);
    }

    public synchronized void injectMetadata(Object metadataObject) {
        this.metadata = this.metadata.with(metadataObject);
    }

    private static class AlreadyAcknowledgedHandler
    implements RabbitMQAckHandler,
    RabbitMQFailureHandler {
        static final AlreadyAcknowledgedHandler INSTANCE = new AlreadyAcknowledgedHandler();

        private AlreadyAcknowledgedHandler() {
        }

        @Override
        public <V> CompletionStage<Void> handle(IncomingRabbitMQMessage<V> message, Context context) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public <V> CompletionStage<Void> handle(IncomingRabbitMQMessage<V> message, Context context, Throwable reason) {
            return CompletableFuture.completedFuture(null);
        }
    }
}

