/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq.fault;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.reactive.messaging.rabbitmq.ConnectionHolder;
import io.smallrye.reactive.messaging.rabbitmq.IncomingRabbitMQMessage;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnector;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.rabbitmq.fault.RabbitMQFailureHandler;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQLogging;
import io.vertx.mutiny.core.Context;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.concurrent.CompletionStage;

public class RabbitMQFailStop
implements RabbitMQFailureHandler {
    private final String channel;
    private final RabbitMQConnector connector;

    public RabbitMQFailStop(RabbitMQConnector connector, String channel) {
        this.connector = connector;
        this.channel = channel;
    }

    @Override
    public <V> CompletionStage<Void> handle(IncomingRabbitMQMessage<V> msg, Context context, Throwable reason) {
        RabbitMQLogging.log.nackedFailMessage(this.channel);
        this.connector.reportIncomingFailure(this.channel, reason);
        return ConnectionHolder.runOnContextAndReportFailure(context, reason, msg, m -> m.rejectMessage(reason));
    }

    @ApplicationScoped
    @Identifier(value="fail")
    public static class Factory
    implements RabbitMQFailureHandler.Factory {
        @Override
        public RabbitMQFailureHandler create(RabbitMQConnectorIncomingConfiguration config, RabbitMQConnector connector) {
            return new RabbitMQFailStop(connector, config.getChannel());
        }
    }
}

