/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.lang;

import io.smallrye.mutiny.vertx.codegen.AbstractMutinyGenerator;
import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.smallrye.mutiny.vertx.codegen.lang.ConditionalCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ConstructorWithDelegateParameterCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ConstructorWithGenericTypesCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.DelegateFieldCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.GetDelegateMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.NoArgConstructorCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ToMultiMethodCodeWriter;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Helper;
import io.vertx.codegen.type.ClassTypeInfo;
import java.io.PrintWriter;

public class ImplClassCodeWriter
implements ConditionalCodeWriter {
    private final AbstractMutinyGenerator generator;

    public ImplClassCodeWriter(AbstractMutinyGenerator mutinyGenerator) {
        this.generator = mutinyGenerator;
    }

    @Override
    public void generate(ClassModel model, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        writer.println();
        writer.print("class ");
        writer.print(type.getSimpleName());
        writer.print("Impl");
        writer.print(CodeGenHelper.genOptTypeParamsDecl(type, ""));
        writer.print(" implements ");
        writer.print(Helper.getSimpleName((String)model.getIfaceFQCN()));
        writer.println(" {");
        new DelegateFieldCodeWriter().generate(model, writer);
        new GetDelegateMethodCodeWriter().generate(model, writer);
        new NoArgConstructorCodeWriter(type.getSimpleName() + "Impl").generate(model, writer);
        new ConstructorWithDelegateParameterCodeWriter(type.getSimpleName() + "Impl").generate(model, writer);
        new ConstructorWithGenericTypesCodeWriter(type.getSimpleName() + "Impl").generate(model, writer);
        if (model.isReadStream()) {
            new ToMultiMethodCodeWriter().generate(model, writer);
        }
        this.generator.generateClassBody(model, writer);
        writer.println("}");
    }

    @Override
    public boolean test(ClassModel classModel) {
        return !classModel.isConcrete();
    }
}

