/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class DirConfigSource
implements ConfigSource {
    private static final Logger LOG = Logger.getLogger((String)"io.smallrye.config");
    private final File dir;
    private final int ordinal;
    private final Map<String, String> props;

    DirConfigSource(File dir) {
        this(dir, 100);
    }

    public DirConfigSource(File dir, int ordinal) {
        this.dir = dir;
        this.props = this.scan(dir);
        this.ordinal = this.props.containsKey("config_ordinal") ? Integer.parseInt(this.props.getOrDefault("config_ordinal", "100")) : ordinal;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    public String getValue(String key) {
        return this.props.get(key);
    }

    public String getName() {
        return "DirConfigSource[dir=" + this.dir.getAbsolutePath() + "]";
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> scan(File directory) {
        if (directory == null) return Collections.emptyMap();
        if (!directory.isDirectory()) return Collections.emptyMap();
        try (Stream<Path> stream = Files.walk(directory.toPath(), new FileVisitOption[0]);){
            Map<String, String> map = stream.filter(p -> p.toFile().isFile()).collect(Collectors.toMap(it -> it.getFileName().toString(), this::readContent));
            return map;
        }
        catch (Throwable t) {
            LOG.warnf("Unable to read content from file %s", (Object)directory.getAbsolutePath());
        }
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readContent(Path file) {
        try (Stream<String> stream = Files.lines(file);){
            String string = stream.collect(Collectors.joining());
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

