/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.io.Serializable;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class EnvConfigSource
implements ConfigSource,
Serializable {
    private static final Pattern PATTERN = Pattern.compile("[^a-zA-Z0-9_]");

    EnvConfigSource() {
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(AccessController.doPrivileged(System::getenv));
    }

    public int getOrdinal() {
        return 300;
    }

    public String getValue(String name) {
        if (name == null) {
            return null;
        }
        Map<String, String> properties = this.getProperties();
        String value = properties.get(name);
        if (value != null) {
            return value;
        }
        String sanitizedName = PATTERN.matcher(name).replaceAll("_");
        value = properties.get(sanitizedName);
        if (value != null) {
            return value;
        }
        return properties.get(sanitizedName.toUpperCase());
    }

    public String getName() {
        return "EnvConfigSource";
    }
}

