/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.utils.ConfigSourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class PropertiesConfigSource
implements ConfigSource,
Serializable {
    private final Map<String, String> properties;
    private final String source;
    private final int ordinal;

    public PropertiesConfigSource(URL url) throws IOException {
        this.source = url.toString();
        try (InputStream in = url.openStream();){
            Properties p = new Properties();
            p.load(in);
            this.properties = ConfigSourceUtil.propertiesToMap(p);
        }
        this.ordinal = Integer.parseInt(this.properties.getOrDefault("config_ordinal", "100"));
    }

    public PropertiesConfigSource(Properties properties, String source) {
        this.properties = ConfigSourceUtil.propertiesToMap(properties);
        this.source = source;
        this.ordinal = Integer.parseInt(properties.getProperty("config_ordinal", "100"));
    }

    public PropertiesConfigSource(Map<String, String> properties, String source, int ordinal) {
        this.properties = new HashMap<String, String>(properties);
        this.source = source;
        this.ordinal = properties.containsKey("config_ordinal") ? Integer.parseInt(properties.getOrDefault("config_ordinal", "100")) : ordinal;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getValue(String s) {
        return this.properties.get(s);
    }

    public String getName() {
        return "PropertiesConfigSource[source=" + this.source + "]";
    }

    public String toString() {
        return this.getName();
    }
}

