/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.utils.ConfigSourceUtil;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;

class SysPropConfigSource
implements ConfigSource,
Serializable {
    SysPropConfigSource() {
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(ConfigSourceUtil.propertiesToMap(AccessController.doPrivileged(System::getProperties)));
    }

    public int getOrdinal() {
        return 400;
    }

    public String getValue(String s) {
        return AccessController.doPrivileged(() -> System.getProperty(s));
    }

    public String getName() {
        return "SysPropConfigSource";
    }
}

