/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigFactory;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.PropertiesConfigSourceProvider;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SysPropConfigSource;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfigBuilder
implements ConfigBuilder {
    private static final String META_INF_MICROPROFILE_CONFIG_PROPERTIES = "META-INF/microprofile-config.properties";
    private static final String WEB_INF_MICROPROFILE_CONFIG_PROPERTIES = "WEB-INF/classes/META-INF/microprofile-config.properties";
    private List<ConfigSource> sources = new ArrayList<ConfigSource>();
    private Function<ConfigSource, ConfigSource> sourceWrappers = UnaryOperator.identity();
    private Map<Type, ConverterWithPriority> converters = new HashMap<Type, ConverterWithPriority>();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private boolean addDefaultSources = false;
    private boolean addDiscoveredSources = false;
    private boolean addDiscoveredConverters = false;

    public ConfigBuilder addDiscoveredSources() {
        this.addDiscoveredSources = true;
        return this;
    }

    public ConfigBuilder addDiscoveredConverters() {
        this.addDiscoveredConverters = true;
        return this;
    }

    private List<ConfigSource> discoverSources() {
        ArrayList<ConfigSource> discoveredSources = new ArrayList<ConfigSource>();
        ServiceLoader<ConfigSource> configSourceLoader = ServiceLoader.load(ConfigSource.class, this.classLoader);
        configSourceLoader.forEach(discoveredSources::add);
        ServiceLoader<ConfigSourceProvider> configSourceProviderLoader = ServiceLoader.load(ConfigSourceProvider.class, this.classLoader);
        configSourceProviderLoader.forEach(configSourceProvider -> configSourceProvider.getConfigSources(this.classLoader).forEach(discoveredSources::add));
        return discoveredSources;
    }

    private List<Converter> discoverConverters() {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        ServiceLoader<Converter> converterLoader = ServiceLoader.load(Converter.class, this.classLoader);
        converterLoader.forEach(converters::add);
        return converters;
    }

    public ConfigBuilder addDefaultSources() {
        this.addDefaultSources = true;
        return this;
    }

    private List<ConfigSource> getDefaultSources() {
        ArrayList<ConfigSource> defaultSources = new ArrayList<ConfigSource>();
        defaultSources.add(new EnvConfigSource());
        defaultSources.add(new SysPropConfigSource());
        defaultSources.addAll((Collection<ConfigSource>)new PropertiesConfigSourceProvider(META_INF_MICROPROFILE_CONFIG_PROPERTIES, true, this.classLoader).getConfigSources(this.classLoader));
        defaultSources.addAll((Collection<ConfigSource>)new PropertiesConfigSourceProvider(WEB_INF_MICROPROFILE_CONFIG_PROPERTIES, true, this.classLoader).getConfigSources(this.classLoader));
        return defaultSources;
    }

    public ConfigBuilder forClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ConfigBuilder withSources(ConfigSource ... configSources) {
        Collections.addAll(this.sources, configSources);
        return this;
    }

    public ConfigBuilder withConverters(Converter<?>[] converters) {
        for (Converter<?> converter : converters) {
            Type type = this.getConverterType(converter.getClass());
            if (type == null) {
                throw new IllegalStateException("Can not add converter " + converter + " that is not parameterized with a type");
            }
            SmallRyeConfigBuilder.addConverter(type, SmallRyeConfigBuilder.getPriority(converter), converter, this.converters);
        }
        return this;
    }

    public <T> ConfigBuilder withConverter(Class<T> type, int priority, Converter<T> converter) {
        SmallRyeConfigBuilder.addConverter(type, priority, converter, this.converters);
        return this;
    }

    public SmallRyeConfigBuilder withWrapper(UnaryOperator<ConfigSource> wrapper) {
        this.sourceWrappers = this.sourceWrappers.andThen(wrapper);
        return this;
    }

    private static void addConverter(Type type, int priority, Converter converter, Map<Type, ConverterWithPriority> converters) {
        ConverterWithPriority oldConverter = converters.get(type);
        int newPriority = SmallRyeConfigBuilder.getPriority(converter);
        if (oldConverter == null || priority > oldConverter.priority) {
            converters.put(type, new ConverterWithPriority(converter, newPriority));
        }
    }

    private Type getConverterType(Class clazz) {
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Converter " + clazz + " must be parameterized with a single type");
            }
            return typeArguments[0];
        }
        return this.getConverterType(clazz.getSuperclass());
    }

    private static int getPriority(Converter<?> converter) {
        int priority = 100;
        Priority priorityAnnotation = converter.getClass().getAnnotation(Priority.class);
        if (priorityAnnotation != null) {
            priority = priorityAnnotation.value();
        }
        return priority;
    }

    public Config build() {
        ArrayList<ConfigSource> sources = new ArrayList<ConfigSource>(this.sources);
        if (this.addDiscoveredSources) {
            sources.addAll(this.discoverSources());
        }
        if (this.addDefaultSources) {
            sources.addAll(this.getDefaultSources());
        }
        HashMap<Type, ConverterWithPriority> converters = new HashMap<Type, ConverterWithPriority>(this.converters);
        if (this.addDiscoveredConverters) {
            for (Converter converter : this.discoverConverters()) {
                Type type2 = this.getConverterType(converter.getClass());
                if (type2 == null) {
                    throw new IllegalStateException("Can not add converter " + converter + " that is not parameterized with a type");
                }
                SmallRyeConfigBuilder.addConverter(type2, SmallRyeConfigBuilder.getPriority(converter), converter, converters);
            }
        }
        Collections.sort(sources, new Comparator<ConfigSource>(){

            @Override
            public int compare(ConfigSource o1, ConfigSource o2) {
                int v2;
                int v1 = o1.getOrdinal();
                if (v1 > (v2 = o2.getOrdinal())) {
                    return -11;
                }
                if (v1 < v2) {
                    return 1;
                }
                if (o2.getName() != null && o1.getName() != null) {
                    return o2.getName().compareTo(o1.getName());
                }
                return 0;
            }
        });
        Function<ConfigSource, ConfigSource> sourceWrappers = this.sourceWrappers;
        ListIterator<ConfigSource> it = sources.listIterator();
        while (it.hasNext()) {
            it.set(sourceWrappers.apply((ConfigSource)it.next()));
        }
        HashMap<Type, Converter> configConverters = new HashMap<Type, Converter>();
        converters.forEach((type, converterWithPriority) -> configConverters.put((Type)type, ((ConverterWithPriority)converterWithPriority).converter));
        return this.newConfig(sources, configConverters);
    }

    protected Config newConfig(List<ConfigSource> sources, Map<Type, Converter> configConverters) {
        ServiceLoader<ConfigFactory> factoryLoader = ServiceLoader.load(ConfigFactory.class, this.classLoader);
        Iterator<ConfigFactory> iter = factoryLoader.iterator();
        if (!iter.hasNext()) {
            return new SmallRyeConfig(sources, configConverters);
        }
        ConfigFactory factory = iter.next();
        return factory.newConfig(sources, configConverters);
    }

    private static class ConverterWithPriority {
        private final Converter converter;
        private final int priority;

        private ConverterWithPriority(Converter converter, int priority) {
            this.converter = converter;
            this.priority = priority;
        }
    }
}

