/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.jta.context.propagation;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.CDI;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class JtaContextProvider
implements ThreadContextProvider {
    private static final Logger logger = Logger.getLogger(JtaContextProvider.class.getName());

    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        if (this.isCdiUnavailable()) {
            return null;
        }
        Transaction capturedTransaction = this.currentTransaction();
        return () -> {
            Transaction currentTransaction = this.currentTransaction();
            if (capturedTransaction != null) {
                if (capturedTransaction != currentTransaction) {
                    if (currentTransaction != null) {
                        this.suspendTransaction();
                    }
                    this.resumeTransaction(capturedTransaction);
                } else {
                    logger.fine("Keeping current transaction " + currentTransaction);
                }
            } else if (currentTransaction != null) {
                this.suspendTransaction();
            }
            return () -> {
                if (capturedTransaction != null) {
                    if (capturedTransaction != currentTransaction) {
                        this.suspendTransaction();
                        if (currentTransaction != null) {
                            this.resumeTransaction(currentTransaction);
                        }
                    } else {
                        logger.fine("Keeping (not restoring) current transaction " + currentTransaction);
                    }
                } else if (currentTransaction != null) {
                    this.resumeTransaction(currentTransaction);
                }
            };
        };
    }

    private void resumeTransaction(Transaction transaction) {
        try {
            logger.fine("Resuming transaction " + transaction);
            this.tm().resume(transaction);
        }
        catch (IllegalStateException | InvalidTransactionException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private void suspendTransaction() {
        try {
            Transaction t = this.tm().suspend();
            logger.fine("Suspending transaction " + t);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private Transaction currentTransaction() {
        try {
            return this.tm().getTransaction();
        }
        catch (SystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    private TransactionManager tm() {
        return (TransactionManager)CDI.current().select(TransactionManager.class, new Annotation[0]).get();
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        if (this.isCdiUnavailable()) {
            return null;
        }
        return () -> {
            Transaction currentTransaction = this.currentTransaction();
            if (currentTransaction != null) {
                this.suspendTransaction();
            }
            return () -> {
                if (currentTransaction != null) {
                    this.resumeTransaction(currentTransaction);
                }
            };
        };
    }

    public String getThreadContextType() {
        return "Transaction";
    }

    private boolean isCdiUnavailable() {
        try {
            return CDI.current() == null;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }
}

