package io.smallrye.context;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

import io.smallrye.context.impl.JdkSpecificImpl;

public class JdkSpecific {

    private final static JdkSpecificImpl impl = new JdkSpecificImpl();

    public interface Contract {
        public <T> CompletionStage<T> newCompletionStageWrapper(SmallRyeThreadContext threadContext,
                CompletionStage<T> future, Executor executor);

        public <T> CompletableFuture<T> newCompletableFutureWrapper(SmallRyeThreadContext threadContext,
                CompletableFuture<T> future, Executor executor, int flags);
    }

    public static <T> CompletionStage<T> newCompletionStageWrapper(SmallRyeThreadContext threadContext,
            CompletionStage<T> future, Executor executor) {
        return impl.newCompletionStageWrapper(threadContext, future, executor);
    }

    public static <T> CompletableFuture<T> newCompletableFutureWrapper(SmallRyeThreadContext threadContext,
            CompletableFuture<T> future, Executor executor, int flags) {
        return impl.newCompletableFutureWrapper(threadContext, future, executor, flags);
    }
}
