/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.JdkSpecific;
import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.context.impl.Contextualized;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ContextualCompletableFuture<T>
extends CompletableFuture<T>
implements Contextualized {
    protected final SmallRyeThreadContext context;
    protected final Executor executor;
    protected final boolean minimal;

    public ContextualCompletableFuture(SmallRyeThreadContext context, Executor executor, boolean minimal) {
        this.context = context;
        this.executor = executor;
        this.minimal = minimal;
    }

    protected void checkDefaultExecutor() {
        if (this.executor == null) {
            throw new UnsupportedOperationException("Async methods not supported when no executor is specified");
        }
    }

    private void checkMinimal() {
        if (this.minimal) {
            throw new UnsupportedOperationException("Completion methods not supported for minimal CompletionStage instances");
        }
    }

    @Override
    public boolean complete(T value) {
        this.checkMinimal();
        return super.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        this.checkMinimal();
        return super.completeExceptionally(ex);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.checkMinimal();
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public void obtrudeValue(T value) {
        this.checkMinimal();
        super.obtrudeValue(value);
    }

    @Override
    public void obtrudeException(Throwable ex) {
        this.checkMinimal();
        super.obtrudeException(ex);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        if (this.minimal) {
            CompletableFuture ret = JdkSpecific.newCompletableFuture(this.context, this.executor);
            super.whenComplete((T val, U x) -> {
                if (x != null) {
                    ret.completeExceptionally((Throwable)x);
                } else {
                    ret.complete(val);
                }
            });
            return ret;
        }
        return this;
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return super.exceptionally((Function)this.context.contextualFunctionUnlessContextualized(fn));
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return super.handle((BiFunction)this.context.contextualFunctionUnlessContextualized(fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        this.checkDefaultExecutor();
        return super.handleAsync((BiFunction)this.context.contextualFunctionUnlessContextualized(fn), this.executor);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return super.handleAsync((BiFunction)this.context.contextualFunctionUnlessContextualized(fn), executor);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return super.thenApply((Function)this.context.contextualFunctionUnlessContextualized(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        this.checkDefaultExecutor();
        return super.thenApplyAsync((Function)this.context.contextualFunctionUnlessContextualized(fn), this.executor);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return super.thenApplyAsync((Function)this.context.contextualFunctionUnlessContextualized(fn), executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return super.thenAccept((Consumer)this.context.contextualConsumerUnlessContextualized(action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        this.checkDefaultExecutor();
        return super.thenAcceptAsync((Consumer)this.context.contextualConsumerUnlessContextualized(action), this.executor);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return super.thenAcceptAsync((Consumer)this.context.contextualConsumerUnlessContextualized(action), executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return super.thenRun(this.context.contextualRunnableUnlessContextualized(action));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        this.checkDefaultExecutor();
        return super.thenRunAsync(this.context.contextualRunnableUnlessContextualized(action), this.executor);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return super.thenRunAsync(this.context.contextualRunnableUnlessContextualized(action), executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return super.thenCombine((CompletionStage)other, (BiFunction)this.context.contextualFunctionUnlessContextualized(fn));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        this.checkDefaultExecutor();
        return super.thenCombineAsync((CompletionStage)other, (BiFunction)this.context.contextualFunctionUnlessContextualized(fn), this.executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return super.thenCombineAsync((CompletionStage)other, (BiFunction)this.context.contextualFunctionUnlessContextualized(fn), executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return super.thenAcceptBoth((CompletionStage)other, (BiConsumer)this.context.contextualConsumerUnlessContextualized(action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        this.checkDefaultExecutor();
        return super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)this.context.contextualConsumerUnlessContextualized(action), this.executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)this.context.contextualConsumerUnlessContextualized(action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return super.runAfterBoth((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        this.checkDefaultExecutor();
        return super.runAfterBothAsync((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action), this.executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return super.runAfterBothAsync((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action), executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return super.applyToEither((CompletionStage)other, (Function)this.context.contextualFunctionUnlessContextualized(fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        this.checkDefaultExecutor();
        return super.applyToEitherAsync((CompletionStage)other, (Function)this.context.contextualFunctionUnlessContextualized(fn), this.executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return super.applyToEitherAsync((CompletionStage)other, (Function)this.context.contextualFunctionUnlessContextualized(fn), executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return super.acceptEither((CompletionStage)other, (Consumer)this.context.contextualConsumerUnlessContextualized(action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        this.checkDefaultExecutor();
        return super.acceptEitherAsync((CompletionStage)other, (Consumer)this.context.contextualConsumerUnlessContextualized(action), this.executor);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return super.acceptEitherAsync((CompletionStage)other, (Consumer)this.context.contextualConsumerUnlessContextualized(action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return super.runAfterEither((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        this.checkDefaultExecutor();
        return super.runAfterEitherAsync((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action), this.executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return super.runAfterEitherAsync((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action), executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return super.thenCompose((Function)this.context.contextualFunctionUnlessContextualized(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        this.checkDefaultExecutor();
        return super.thenComposeAsync((Function)this.context.contextualFunctionUnlessContextualized(fn), this.executor);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return super.thenComposeAsync((Function)this.context.contextualFunctionUnlessContextualized(fn), executor);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return super.whenComplete((BiConsumer)this.context.contextualConsumerUnlessContextualized(action));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        this.checkDefaultExecutor();
        return super.whenCompleteAsync((BiConsumer)this.context.contextualConsumerUnlessContextualized(action), this.executor);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return super.whenCompleteAsync((BiConsumer)this.context.contextualConsumerUnlessContextualized(action), executor);
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        if (this.minimal) {
            return (CompletableFuture)JdkSpecific.newCompletionStage(this.context, this.executor);
        }
        return JdkSpecific.newCompletableFuture(this.context, this.executor);
    }

    @Override
    public Executor defaultExecutor() {
        return this.executor;
    }

    @Override
    public CompletableFuture<T> copy() {
        return super.copy();
    }

    @Override
    public CompletionStage<T> minimalCompletionStage() {
        return JdkSpecific.newCompletionStage(this.context, this.executor);
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier) {
        this.checkMinimal();
        return super.completeAsync(this.context.contextualSupplierUnlessContextualized(supplier), this.executor);
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        this.checkMinimal();
        return super.completeAsync(this.context.contextualSupplierUnlessContextualized(supplier), executor);
    }

    @Override
    public CompletableFuture<T> orTimeout(long timeout, TimeUnit unit) {
        this.checkMinimal();
        return super.orTimeout(timeout, unit);
    }

    @Override
    public CompletableFuture<T> completeOnTimeout(T value, long timeout, TimeUnit unit) {
        this.checkMinimal();
        return super.completeOnTimeout(value, timeout, unit);
    }

    void superCompleteExceptionally(Throwable x) {
        super.completeExceptionally(x);
    }

    void superComplete(T val) {
        super.complete(val);
    }
}

