/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.api;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.faulttolerance.api.CircuitBreakerMaintenance;
import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.api.FaultToleranceSpiAccess;
import io.smallrye.faulttolerance.api.RateLimitType;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

@Experimental(value="first attempt at providing programmatic API")
public interface FaultTolerance<T> {
    public static CircuitBreakerMaintenance circuitBreakerMaintenance() {
        return FaultToleranceSpiAccess.get().circuitBreakerMaintenance();
    }

    public static <T> Builder<T, Callable<T>> createCallable(Callable<T> action) {
        return FaultToleranceSpiAccess.get().newBuilder(ft -> ft.adaptCallable(action));
    }

    public static <T> Builder<T, Supplier<T>> createSupplier(Supplier<T> action) {
        return FaultToleranceSpiAccess.get().newBuilder(ft -> ft.adaptSupplier(action));
    }

    public static Builder<Void, Runnable> createRunnable(Runnable action) {
        return FaultToleranceSpiAccess.get().newBuilder(ft -> ft.adaptRunnable(action));
    }

    public static <T> Builder<T, FaultTolerance<T>> create() {
        return FaultToleranceSpiAccess.get().newBuilder(Function.identity());
    }

    public static <T> Builder<CompletionStage<T>, Callable<CompletionStage<T>>> createAsyncCallable(Callable<CompletionStage<T>> action) {
        return FaultToleranceSpiAccess.get().newAsyncBuilder(CompletionStage.class, ft -> ft.adaptCallable(action));
    }

    public static <T> Builder<CompletionStage<T>, Supplier<CompletionStage<T>>> createAsyncSupplier(Supplier<CompletionStage<T>> action) {
        return FaultToleranceSpiAccess.get().newAsyncBuilder(CompletionStage.class, ft -> ft.adaptSupplier(action));
    }

    public static Builder<CompletionStage<Void>, Runnable> createAsyncRunnable(Runnable action) {
        return FaultToleranceSpiAccess.get().newAsyncBuilder(CompletionStage.class, ft -> ft.adaptRunnable(action));
    }

    public static <T> Builder<CompletionStage<T>, FaultTolerance<CompletionStage<T>>> createAsync() {
        return FaultToleranceSpiAccess.get().newAsyncBuilder(CompletionStage.class, Function.identity());
    }

    public T call(Callable<T> var1) throws Exception;

    default public T get(Supplier<T> action) {
        try {
            return (T)this.call(action::get);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public void run(Runnable action) {
        try {
            this.call(() -> {
                action.run();
                return null;
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public Callable<T> adaptCallable(Callable<T> action) {
        return () -> this.call(action);
    }

    default public Supplier<T> adaptSupplier(Supplier<T> action) {
        return () -> this.get(action);
    }

    default public Runnable adaptRunnable(Runnable action) {
        return () -> this.run(action);
    }

    public <U> FaultTolerance<U> cast();

    public <U> FaultTolerance<U> castAsync(Class<?> var1);

    public static interface Builder<T, R> {
        public Builder<T, R> withDescription(String var1);

        public BulkheadBuilder<T, R> withBulkhead();

        public CircuitBreakerBuilder<T, R> withCircuitBreaker();

        public FallbackBuilder<T, R> withFallback();

        public RateLimitBuilder<T, R> withRateLimit();

        public RetryBuilder<T, R> withRetry();

        public TimeoutBuilder<T, R> withTimeout();

        public Builder<T, R> withThreadOffload(boolean var1);

        public Builder<T, R> withThreadOffloadExecutor(Executor var1);

        public R build();

        default public Builder<T, R> with(Consumer<Builder<T, R>> consumer) {
            consumer.accept(this);
            return this;
        }

        public static interface TimeoutBuilder<T, R> {
            public TimeoutBuilder<T, R> duration(long var1, ChronoUnit var3);

            public TimeoutBuilder<T, R> onTimeout(Runnable var1);

            public TimeoutBuilder<T, R> onFinished(Runnable var1);

            public Builder<T, R> done();

            default public TimeoutBuilder<T, R> with(Consumer<TimeoutBuilder<T, R>> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static interface RetryBuilder<T, R> {
            public RetryBuilder<T, R> maxRetries(int var1);

            public RetryBuilder<T, R> delay(long var1, ChronoUnit var3);

            public RetryBuilder<T, R> maxDuration(long var1, ChronoUnit var3);

            public RetryBuilder<T, R> jitter(long var1, ChronoUnit var3);

            public RetryBuilder<T, R> retryOn(Collection<Class<? extends Throwable>> var1);

            default public RetryBuilder<T, R> retryOn(Class<? extends Throwable> value) {
                return this.retryOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public RetryBuilder<T, R> abortOn(Collection<Class<? extends Throwable>> var1);

            default public RetryBuilder<T, R> abortOn(Class<? extends Throwable> value) {
                return this.abortOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public RetryBuilder<T, R> whenResult(Predicate<Object> var1);

            @Deprecated(forRemoval=true)
            default public RetryBuilder<T, R> when(Predicate<Throwable> value) {
                return this.whenException(value);
            }

            public RetryBuilder<T, R> whenException(Predicate<Throwable> var1);

            public RetryBuilder<T, R> beforeRetry(Runnable var1);

            public RetryBuilder<T, R> beforeRetry(Consumer<Throwable> var1);

            public ExponentialBackoffBuilder<T, R> withExponentialBackoff();

            public FibonacciBackoffBuilder<T, R> withFibonacciBackoff();

            public CustomBackoffBuilder<T, R> withCustomBackoff();

            public RetryBuilder<T, R> onRetry(Runnable var1);

            public RetryBuilder<T, R> onSuccess(Runnable var1);

            public RetryBuilder<T, R> onFailure(Runnable var1);

            public Builder<T, R> done();

            default public RetryBuilder<T, R> with(Consumer<RetryBuilder<T, R>> consumer) {
                consumer.accept(this);
                return this;
            }

            public static interface CustomBackoffBuilder<T, R> {
                public CustomBackoffBuilder<T, R> strategy(Supplier<CustomBackoffStrategy> var1);

                public RetryBuilder<T, R> done();

                default public CustomBackoffBuilder<T, R> with(Consumer<CustomBackoffBuilder<T, R>> consumer) {
                    consumer.accept(this);
                    return this;
                }
            }

            public static interface FibonacciBackoffBuilder<T, R> {
                public FibonacciBackoffBuilder<T, R> maxDelay(long var1, ChronoUnit var3);

                public RetryBuilder<T, R> done();

                default public FibonacciBackoffBuilder<T, R> with(Consumer<FibonacciBackoffBuilder<T, R>> consumer) {
                    consumer.accept(this);
                    return this;
                }
            }

            public static interface ExponentialBackoffBuilder<T, R> {
                public ExponentialBackoffBuilder<T, R> factor(int var1);

                public ExponentialBackoffBuilder<T, R> maxDelay(long var1, ChronoUnit var3);

                public RetryBuilder<T, R> done();

                default public ExponentialBackoffBuilder<T, R> with(Consumer<ExponentialBackoffBuilder<T, R>> consumer) {
                    consumer.accept(this);
                    return this;
                }
            }
        }

        public static interface RateLimitBuilder<T, R> {
            public RateLimitBuilder<T, R> limit(int var1);

            public RateLimitBuilder<T, R> window(long var1, ChronoUnit var3);

            public RateLimitBuilder<T, R> minSpacing(long var1, ChronoUnit var3);

            public RateLimitBuilder<T, R> type(RateLimitType var1);

            public RateLimitBuilder<T, R> onPermitted(Runnable var1);

            public RateLimitBuilder<T, R> onRejected(Runnable var1);

            public Builder<T, R> done();

            default public RateLimitBuilder<T, R> with(Consumer<RateLimitBuilder<T, R>> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static interface FallbackBuilder<T, R> {
            public FallbackBuilder<T, R> handler(Supplier<T> var1);

            public FallbackBuilder<T, R> handler(Function<Throwable, T> var1);

            public FallbackBuilder<T, R> applyOn(Collection<Class<? extends Throwable>> var1);

            default public FallbackBuilder<T, R> applyOn(Class<? extends Throwable> value) {
                return this.applyOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public FallbackBuilder<T, R> skipOn(Collection<Class<? extends Throwable>> var1);

            default public FallbackBuilder<T, R> skipOn(Class<? extends Throwable> value) {
                return this.skipOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public FallbackBuilder<T, R> when(Predicate<Throwable> var1);

            public Builder<T, R> done();

            default public FallbackBuilder<T, R> with(Consumer<FallbackBuilder<T, R>> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static interface CircuitBreakerBuilder<T, R> {
            public CircuitBreakerBuilder<T, R> failOn(Collection<Class<? extends Throwable>> var1);

            default public CircuitBreakerBuilder<T, R> failOn(Class<? extends Throwable> value) {
                return this.failOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public CircuitBreakerBuilder<T, R> skipOn(Collection<Class<? extends Throwable>> var1);

            default public CircuitBreakerBuilder<T, R> skipOn(Class<? extends Throwable> value) {
                return this.skipOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public CircuitBreakerBuilder<T, R> when(Predicate<Throwable> var1);

            public CircuitBreakerBuilder<T, R> delay(long var1, ChronoUnit var3);

            public CircuitBreakerBuilder<T, R> requestVolumeThreshold(int var1);

            public CircuitBreakerBuilder<T, R> failureRatio(double var1);

            public CircuitBreakerBuilder<T, R> successThreshold(int var1);

            public CircuitBreakerBuilder<T, R> name(String var1);

            public CircuitBreakerBuilder<T, R> onStateChange(Consumer<CircuitBreakerState> var1);

            public CircuitBreakerBuilder<T, R> onSuccess(Runnable var1);

            public CircuitBreakerBuilder<T, R> onFailure(Runnable var1);

            public CircuitBreakerBuilder<T, R> onPrevented(Runnable var1);

            public Builder<T, R> done();

            default public CircuitBreakerBuilder<T, R> with(Consumer<CircuitBreakerBuilder<T, R>> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static interface BulkheadBuilder<T, R> {
            public BulkheadBuilder<T, R> limit(int var1);

            public BulkheadBuilder<T, R> queueSize(int var1);

            public BulkheadBuilder<T, R> onAccepted(Runnable var1);

            public BulkheadBuilder<T, R> onRejected(Runnable var1);

            public BulkheadBuilder<T, R> onFinished(Runnable var1);

            public Builder<T, R> done();

            default public BulkheadBuilder<T, R> with(Consumer<BulkheadBuilder<T, R>> consumer) {
                consumer.accept(this);
                return this;
            }
        }
    }
}

