package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.api.ExponentialBackoff;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link ExponentialBackoffConfig} config interface, do not modify.
 */
public final class ExponentialBackoffNoConfigImpl implements ExponentialBackoffConfig {
    /**
     * Backing annotation instance.
     */
    private final ExponentialBackoff instance;

    private ExponentialBackoffNoConfigImpl(ExponentialBackoff instance) {
        this.instance = instance;
    }

    public static ExponentialBackoffNoConfigImpl create(Supplier<ExponentialBackoff> supplier) {
        if (supplier == null) {
            return null;
        }
        return new ExponentialBackoffNoConfigImpl(supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ExponentialBackoff.class;
    }

    @Override
    public int factor() {
        return instance.factor();
    }

    @Override
    public long maxDelay() {
        return instance.maxDelay();
    }

    @Override
    public ChronoUnit maxDelayUnit() {
        return instance.maxDelayUnit();
    }

    @Override
    public void materialize() {
        // no config, no need to materialize
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @ExponentialBackoff: " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @ExponentialBackoff." + member + ": " + reason);
    }
}
