package io.smallrye.faulttolerance.basicconfig;

import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.Throwable;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link CircuitBreakerConfig} config interface, do not modify.
 */
public final class CircuitBreakerNoConfigImpl implements CircuitBreakerConfig {
    /**
     * Backing annotation instance.
     */
    private final CircuitBreaker instance;

    private CircuitBreakerNoConfigImpl(CircuitBreaker instance) {
        this.instance = instance;
    }

    public static CircuitBreakerNoConfigImpl create(Supplier<CircuitBreaker> supplier) {
        if (supplier == null) {
            return null;
        }
        return new CircuitBreakerNoConfigImpl(supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CircuitBreaker.class;
    }

    @Override
    public Class<? extends Throwable>[] failOn() {
        return instance.failOn();
    }

    @Override
    public Class<? extends Throwable>[] skipOn() {
        return instance.skipOn();
    }

    @Override
    public long delay() {
        return instance.delay();
    }

    @Override
    public ChronoUnit delayUnit() {
        return instance.delayUnit();
    }

    @Override
    public int requestVolumeThreshold() {
        return instance.requestVolumeThreshold();
    }

    @Override
    public double failureRatio() {
        return instance.failureRatio();
    }

    @Override
    public int successThreshold() {
        return instance.successThreshold();
    }

    @Override
    public void materialize() {
        // no config, no need to materialize
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @CircuitBreaker: " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @CircuitBreaker." + member + ": " + reason);
    }
}
