package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link RateLimitConfig} config interface, do not modify.
 */
public final class RateLimitConfigImpl implements RateLimitConfig {
    /**
     * Description for the error message: a fully qualified method name or identifier.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>} or {@code <id>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final RateLimit instance;

    /**
     * Cached value of the {@code RateLimit.value} annotation member; {@code null} if not looked up yet.
     */
    private Integer _value;

    /**
     * Cached value of the {@code RateLimit.window} annotation member; {@code null} if not looked up yet.
     */
    private Long _window;

    /**
     * Cached value of the {@code RateLimit.windowUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _windowUnit;

    /**
     * Cached value of the {@code RateLimit.minSpacing} annotation member; {@code null} if not looked up yet.
     */
    private Long _minSpacing;

    /**
     * Cached value of the {@code RateLimit.minSpacingUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _minSpacingUnit;

    /**
     * Cached value of the {@code RateLimit.type} annotation member; {@code null} if not looked up yet.
     */
    private RateLimitType _type;

    private RateLimitConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(RateLimit.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.rateLimit;
    }

    private RateLimitConfigImpl(String id, RateLimit instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static RateLimitConfigImpl create(FaultToleranceMethod method) {
        if (method.rateLimit == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("rate-limit.enabled", "RateLimit/enabled", method.method)) {
            return null;
        }
        return new RateLimitConfigImpl(method);
    }

    public static RateLimitConfigImpl create(String id, Supplier<RateLimit> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("rate-limit.enabled", "RateLimit/enabled", id)) {
            return null;
        }
        return new RateLimitConfigImpl(id, supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return RateLimit.class;
    }

    @Override
    public int value() {
        if (_value == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.value";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/RateLimit/value";
                _value = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_value == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.rate-limit.value";
                // <annotation>/<member>
                String oldKey = "RateLimit/value";
                _value = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public long window() {
        if (_window == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.window";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/RateLimit/window";
                _window = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_window == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.rate-limit.window";
                // <annotation>/<member>
                String oldKey = "RateLimit/window";
                _window = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_window == null) {
                // annotation value
                _window = instance.window();
            }
        }
        return _window;
    }

    @Override
    public ChronoUnit windowUnit() {
        if (_windowUnit == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.window-unit";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/RateLimit/windowUnit";
                _windowUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_windowUnit == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.rate-limit.window-unit";
                // <annotation>/<member>
                String oldKey = "RateLimit/windowUnit";
                _windowUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_windowUnit == null) {
                // annotation value
                _windowUnit = instance.windowUnit();
            }
        }
        return _windowUnit;
    }

    @Override
    public long minSpacing() {
        if (_minSpacing == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.min-spacing";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/RateLimit/minSpacing";
                _minSpacing = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_minSpacing == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.rate-limit.min-spacing";
                // <annotation>/<member>
                String oldKey = "RateLimit/minSpacing";
                _minSpacing = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_minSpacing == null) {
                // annotation value
                _minSpacing = instance.minSpacing();
            }
        }
        return _minSpacing;
    }

    @Override
    public ChronoUnit minSpacingUnit() {
        if (_minSpacingUnit == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.min-spacing-unit";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/RateLimit/minSpacingUnit";
                _minSpacingUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_minSpacingUnit == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.rate-limit.min-spacing-unit";
                // <annotation>/<member>
                String oldKey = "RateLimit/minSpacingUnit";
                _minSpacingUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_minSpacingUnit == null) {
                // annotation value
                _minSpacingUnit = instance.minSpacingUnit();
            }
        }
        return _minSpacingUnit;
    }

    @Override
    public RateLimitType type() {
        if (_type == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".rate-limit.type";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/RateLimit/type";
                _type = config.getOptionalValue(newKey, RateLimitType.class).or(() -> config.getOptionalValue(oldKey, RateLimitType.class)).orElse(null);
            }
            if (_type == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.rate-limit.type";
                // <annotation>/<member>
                String oldKey = "RateLimit/type";
                _type = config.getOptionalValue(newKey, RateLimitType.class).or(() -> config.getOptionalValue(oldKey, RateLimitType.class)).orElse(null);
            }
            if (_type == null) {
                // annotation value
                _type = instance.type();
            }
        }
        return _type;
    }

    @Override
    public void materialize() {
        value();
        window();
        windowUnit();
        minSpacing();
        minSpacingUnit();
        type();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @RateLimit on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @RateLimit." + member + " on " + description + ": " + reason);
    }
}
