package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link TimeoutConfig} config interface, do not modify.
 */
public final class TimeoutConfigImpl implements TimeoutConfig {
    /**
     * Description for the error message: a fully qualified method name or identifier.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>} or {@code <id>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final Timeout instance;

    /**
     * Cached value of the {@code Timeout.value} annotation member; {@code null} if not looked up yet.
     */
    private Long _value;

    /**
     * Cached value of the {@code Timeout.unit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _unit;

    private TimeoutConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(Timeout.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.timeout;
    }

    private TimeoutConfigImpl(String id, Timeout instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static TimeoutConfigImpl create(FaultToleranceMethod method) {
        if (method.timeout == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("timeout.enabled", "Timeout/enabled", method.method)) {
            return null;
        }
        return new TimeoutConfigImpl(method);
    }

    public static TimeoutConfigImpl create(String id, Supplier<Timeout> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("timeout.enabled", "Timeout/enabled", id)) {
            return null;
        }
        return new TimeoutConfigImpl(id, supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Timeout.class;
    }

    @Override
    public long value() {
        if (_value == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".timeout.value";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Timeout/value";
                _value = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_value == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.timeout.value";
                // <annotation>/<member>
                String oldKey = "Timeout/value";
                _value = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public ChronoUnit unit() {
        if (_unit == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".timeout.unit";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Timeout/unit";
                _unit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_unit == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.timeout.unit";
                // <annotation>/<member>
                String oldKey = "Timeout/unit";
                _unit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_unit == null) {
                // annotation value
                _unit = instance.unit();
            }
        }
        return _unit;
    }

    @Override
    public void materialize() {
        value();
        unit();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Timeout on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Timeout." + member + " on " + description + ": " + reason);
    }
}
