package io.smallrye.faulttolerance.basicconfig;

import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link TimeoutConfig} config interface, do not modify.
 */
public final class TimeoutNoConfigImpl implements TimeoutConfig {
    /**
     * Backing annotation instance.
     */
    private final Timeout instance;

    private TimeoutNoConfigImpl(Timeout instance) {
        this.instance = instance;
    }

    public static TimeoutNoConfigImpl create(Supplier<Timeout> supplier) {
        if (supplier == null) {
            return null;
        }
        return new TimeoutNoConfigImpl(supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Timeout.class;
    }

    @Override
    public long value() {
        return instance.value();
    }

    @Override
    public ChronoUnit unit() {
        return instance.unit();
    }

    @Override
    public void materialize() {
        // no config, no need to materialize
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Timeout: " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Timeout." + member + ": " + reason);
    }
}
