/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.propagation;

import io.smallrye.context.SmallRyeManagedExecutor;
import io.smallrye.faulttolerance.ExecutorFactory;
import io.smallrye.faulttolerance.propagation.ContextPropagatingScheduledExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;

public class ContextPropagationExecutorFactory
implements ExecutorFactory {
    public ExecutorService createCoreExecutor(int size) {
        return ManagedExecutor.builder().maxAsync(size).build();
    }

    public ExecutorService createExecutor(int coreSize, int size) {
        SmallRyeManagedExecutor.Builder builder = (SmallRyeManagedExecutor.Builder)ManagedExecutor.builder();
        return builder.maxAsync(size).build();
    }

    public ScheduledExecutorService createTimeoutExecutor(int size) {
        ThreadContext threadContext = ThreadContext.builder().build();
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(size);
        return new ContextPropagatingScheduledExecutorService(threadContext, executor);
    }

    public int priority() {
        return 100;
    }
}

