/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.bulkhead;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadBase;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import org.jboss.logging.Logger;

public class CompletionStageBulkhead<V>
extends BulkheadBase<CompletionStage<V>> {
    private static final Logger logger = Logger.getLogger(CompletionStageBulkhead.class);
    private final ExecutorService executor;
    private final int queueSize;
    private final Semaphore workSemaphore;
    private final Semaphore capacitySemaphore;

    public CompletionStageBulkhead(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, ExecutorService executor, int size, int queueSize, BulkheadBase.MetricsRecorder recorder) {
        super(description, delegate, recorder);
        this.workSemaphore = new Semaphore(size);
        this.capacitySemaphore = new Semaphore(size + queueSize);
        this.queueSize = queueSize;
        this.executor = executor;
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        if (this.capacitySemaphore.tryAcquire()) {
            CompletionStageBulkheadTask task = new CompletionStageBulkheadTask(System.nanoTime(), ctx);
            this.executor.execute(task);
            this.recorder.bulkheadQueueEntered();
            return task.result;
        }
        this.recorder.bulkheadRejected();
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally((Throwable)this.bulkheadRejected());
        return result;
    }

    public int getQueueSize() {
        return Math.max(0, this.queueSize - this.capacitySemaphore.availablePermits());
    }

    private void releaseSemaphores() {
        this.workSemaphore.release();
        this.capacitySemaphore.release();
    }

    private class CompletionStageBulkheadTask
    implements Runnable {
        private final long timeEnqueued;
        private final CompletableFuture<V> result = new CompletableFuture();
        private final InvocationContext<CompletionStage<V>> context;

        private CompletionStageBulkheadTask(long timeEnqueued, InvocationContext<CompletionStage<V>> context) {
            this.timeEnqueued = timeEnqueued;
            this.context = context;
        }

        @Override
        public void run() {
            try {
                CompletionStageBulkhead.this.workSemaphore.acquire();
            }
            catch (InterruptedException e) {
                logger.error((Object)"Bulkhead worker interrupted, exiting", (Throwable)e);
                this.result.completeExceptionally(e);
                return;
            }
            long startTime = System.nanoTime();
            CompletionStageBulkhead.this.recorder.bulkheadQueueLeft(startTime - this.timeEnqueued);
            CompletionStageBulkhead.this.recorder.bulkheadEntered();
            try {
                CompletionStage rawResult = CompletionStageBulkhead.this.delegate.apply(this.context);
                rawResult.whenComplete((value, error) -> {
                    CompletionStageBulkhead.this.releaseSemaphores();
                    CompletionStageBulkhead.this.recorder.bulkheadLeft(System.nanoTime() - startTime);
                    if (error != null) {
                        this.result.completeExceptionally((Throwable)error);
                    } else {
                        this.result.complete(value);
                    }
                });
            }
            catch (Exception e) {
                CompletionStageBulkhead.this.releaseSemaphores();
                CompletionStageBulkhead.this.recorder.bulkheadLeft(System.nanoTime() - startTime);
                this.result.completeExceptionally(e);
            }
        }
    }
}

