/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.circuit.breaker;

import io.smallrye.faulttolerance.core.circuit.breaker.RollingWindow;
import java.util.BitSet;

final class BitsetRollingWindow
implements RollingWindow {
    private final BitSet failures;
    private final int size;
    private final int failureThreshold;
    private int index = 0;
    private int counter = 0;

    BitsetRollingWindow(int size, int failureThreshold) {
        this.failures = new BitSet(size);
        this.size = size;
        this.failureThreshold = failureThreshold;
    }

    @Override
    public synchronized boolean recordSuccess() {
        this.failures.clear(this.nextIndex());
        return this.failureThresholdReached();
    }

    @Override
    public synchronized boolean recordFailure() {
        this.failures.set(this.nextIndex());
        return this.failureThresholdReached();
    }

    private int nextIndex() {
        ++this.counter;
        int result = this.index;
        this.index = (this.index + 1) % this.size;
        return result;
    }

    private boolean failureThresholdReached() {
        if (this.counter < this.size) {
            return false;
        }
        return this.failures.cardinality() >= this.failureThreshold;
    }
}

