/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.fallback;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

public class CompletionStageFallback<V>
extends Fallback<CompletionStage<V>> {
    private final Executor executor;

    public CompletionStageFallback(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, FallbackFunction<CompletionStage<V>> fallback, Executor executor, Fallback.MetricsRecorder metricsRecorder) {
        super(delegate, description, fallback, metricsRecorder);
        this.executor = executor;
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        CompletableFuture result = new CompletableFuture();
        this.executor.execute(() -> {
            CompletableFuture<Object> originalResult;
            try {
                originalResult = (CompletableFuture<Object>)this.delegate.apply(ctx);
            }
            catch (Exception e) {
                CompletableFuture<Object> failure = new CompletableFuture<Object>();
                failure.completeExceptionally(e);
                originalResult = failure;
            }
            originalResult.whenComplete((value, exception) -> {
                if (value != null) {
                    result.complete(value);
                    return;
                }
                if (exception instanceof InterruptedException || Thread.interrupted()) {
                    result.completeExceptionally(new InterruptedException());
                    return;
                }
                try {
                    this.metricsRecorder.fallbackCalled();
                    ((CompletionStage)this.fallback.call((Throwable)exception)).whenComplete((fallbackValue, fallbackException) -> {
                        if (fallbackValue != null) {
                            result.complete(fallbackValue);
                        } else {
                            result.completeExceptionally((Throwable)fallbackException);
                        }
                    });
                }
                catch (Exception e) {
                    result.completeExceptionally(e);
                }
            });
        });
        return result;
    }
}

