/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.fallback;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;

public class Fallback<V>
implements FaultToleranceStrategy<V> {
    final FaultToleranceStrategy<V> delegate;
    final String description;
    final FallbackFunction<V> fallback;
    final MetricsRecorder metricsRecorder;

    public Fallback(FaultToleranceStrategy<V> delegate, String description, FallbackFunction<V> fallback, MetricsRecorder metricsRecorder) {
        this.delegate = delegate;
        this.description = description;
        this.fallback = fallback;
        this.metricsRecorder = metricsRecorder == null ? MetricsRecorder.NO_OP : metricsRecorder;
    }

    @Override
    public V apply(InvocationContext<V> ctx) throws Exception {
        try {
            return this.delegate.apply(ctx);
        }
        catch (Exception e) {
            Exception failure = e;
            if (failure instanceof InterruptedException || Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.metricsRecorder.fallbackCalled();
            return this.fallback.call(failure);
        }
    }

    public static interface MetricsRecorder {
        public static final MetricsRecorder NO_OP = () -> {};

        public void fallbackCalled();
    }
}

