/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.circuit.breaker;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerListener;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;

public class CompletionStageCircuitBreaker<V>
extends CircuitBreaker<CompletionStage<V>> {
    public CompletionStageCircuitBreaker(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, SetOfThrowables failOn, SetOfThrowables skipOn, long delayInMillis, int requestVolumeThreshold, double failureRatio, int successThreshold, Stopwatch stopwatch, CircuitBreaker.MetricsRecorder metricsRecorder) {
        super(delegate, description, failOn, skipOn, delayInMillis, requestVolumeThreshold, failureRatio, successThreshold, stopwatch, metricsRecorder);
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) throws Exception {
        CircuitBreaker.State currentState = (CircuitBreaker.State)this.state.get();
        switch (currentState.id) {
            case 0: {
                return this.inClosed(ctx, currentState);
            }
            case 1: {
                return this.inOpen(ctx, currentState);
            }
            case 2: {
                return this.inHalfOpen(ctx, currentState);
            }
        }
        throw new AssertionError((Object)("Invalid circuit breaker state: " + currentState.id));
    }

    private CompletionStage<V> inClosed(InvocationContext<CompletionStage<V>> target, CircuitBreaker.State state) {
        try {
            CompletionStage<V> result = this.delegate.apply(target);
            return result.handle((val, error) -> {
                if (error != null) {
                    throw this.onFailure(state, (Throwable)error);
                }
                this.metricsRecorder.circuitBreakerSucceeded();
                boolean failureThresholdReached = state.rollingWindow.recordSuccess();
                if (failureThresholdReached) {
                    this.toOpen(state);
                }
                this.listeners.forEach(CircuitBreakerListener::succeeded);
                return val;
            });
        }
        catch (Throwable e) {
            CompletionException failure = this.onFailure(state, e);
            return this.failedCompletionStage(failure);
        }
    }

    private CompletionStage<V> failedCompletionStage(Throwable failure) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(failure);
        return result;
    }

    private CompletionException onFailure(CircuitBreaker.State state, Throwable e) {
        boolean failureThresholdReached;
        boolean isFailure;
        boolean bl = isFailure = !this.isConsideredSuccess(e);
        if (isFailure) {
            this.listeners.forEach(CircuitBreakerListener::failed);
            this.metricsRecorder.circuitBreakerFailed();
        } else {
            this.listeners.forEach(CircuitBreakerListener::succeeded);
            this.metricsRecorder.circuitBreakerSucceeded();
        }
        boolean bl2 = failureThresholdReached = isFailure ? state.rollingWindow.recordFailure() : state.rollingWindow.recordSuccess();
        if (failureThresholdReached) {
            long now;
            this.openStart = now = System.nanoTime();
            this.previousClosedTime.addAndGet(now - this.closedStart);
            this.metricsRecorder.circuitBreakerClosedToOpen();
            this.toOpen(state);
        }
        if (e instanceof CompletionException) {
            return (CompletionException)e;
        }
        return new CompletionException(e);
    }

    private CompletionStage<V> inOpen(InvocationContext<CompletionStage<V>> target, CircuitBreaker.State state) throws Exception {
        long now;
        if (state.runningStopwatch.elapsedTimeInMillis() < this.delayInMillis) {
            this.metricsRecorder.circuitBreakerRejected();
            this.listeners.forEach(CircuitBreakerListener::rejected);
            return this.failedCompletionStage((Throwable)new CircuitBreakerOpenException(this.description + " circuit breaker is open"));
        }
        this.halfOpenStart = now = System.nanoTime();
        this.previousOpenTime.addAndGet(now - this.openStart);
        this.toHalfOpen(state);
        return this.apply((InvocationContext)target);
    }

    private CompletionStage<V> inHalfOpen(InvocationContext<CompletionStage<V>> target, CircuitBreaker.State state) {
        try {
            CompletionStage<V> result = this.delegate.apply(target);
            this.metricsRecorder.circuitBreakerSucceeded();
            int successes = state.consecutiveSuccesses.incrementAndGet();
            if (successes >= this.successThreshold) {
                long now;
                this.closedStart = now = System.nanoTime();
                this.previousHalfOpenTime.addAndGet(now - this.halfOpenStart);
                this.toClosed(state);
            }
            this.listeners.forEach(CircuitBreakerListener::succeeded);
            return result;
        }
        catch (Throwable e) {
            this.metricsRecorder.circuitBreakerFailed();
            this.listeners.forEach(CircuitBreakerListener::failed);
            this.toOpen(state);
            return this.failedCompletionStage(e);
        }
    }
}

