/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.retry;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.retry.Delay;
import io.smallrye.faulttolerance.core.retry.Retry;
import io.smallrye.faulttolerance.core.stopwatch.RunningStopwatch;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

public class CompletionStageRetry<V>
extends Retry<CompletionStage<V>> {
    public CompletionStageRetry(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, SetOfThrowables retryOn, SetOfThrowables abortOn, long maxRetries, long maxTotalDurationInMillis, Delay delayBetweenRetries, Stopwatch stopwatch, Retry.MetricsRecorder metricsRecorder) {
        super(delegate, description, retryOn, abortOn, maxRetries, maxTotalDurationInMillis, delayBetweenRetries, stopwatch, metricsRecorder);
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        RunningStopwatch runningStopwatch = this.stopwatch.start();
        return this.doRetry(ctx, 0, runningStopwatch, null);
    }

    public CompletionStage<V> doRetry(InvocationContext<CompletionStage<V>> target, int attempt, RunningStopwatch stopwatch, Throwable latestFailure) {
        if (attempt != 0) {
            if ((long)attempt <= this.maxRetries) {
                this.metricsRecorder.retryRetried();
                try {
                    this.delayBetweenRetries.sleep();
                }
                catch (InterruptedException e) {
                    this.metricsRecorder.retryFailed();
                    return this.erroneousResult(e);
                }
                catch (Exception e) {
                    this.metricsRecorder.retryFailed();
                    if (Thread.interrupted()) {
                        return this.erroneousResult(new InterruptedException());
                    }
                    return this.erroneousResult(e);
                }
            } else {
                this.metricsRecorder.retryFailed();
                return this.erroneousResult(latestFailure);
            }
        }
        if (stopwatch.elapsedTimeInMillis() > this.maxTotalDurationInMillis) {
            if (latestFailure != null) {
                this.metricsRecorder.retryFailed();
                return this.erroneousResult(latestFailure);
            }
            this.metricsRecorder.retryFailed();
            return this.erroneousResult((Throwable)new FaultToleranceException(this.description + " reached max retries or max retry duration"));
        }
        try {
            return this.delegate.apply(target).handle((x$0, x$1) -> new DelegateResultCarrier(x$0, (Throwable)x$1)).thenCompose(result -> {
                Throwable error = result.error;
                if (error == null) {
                    this.recordSuccess(attempt);
                    return CompletableFuture.completedFuture(result.value);
                }
                this.metricsRecorder.retryFailed();
                if (this.shouldAbortRetrying(error)) {
                    this.metricsRecorder.retryFailed();
                    if (error instanceof RuntimeException) {
                        throw (RuntimeException)error;
                    }
                    throw new CompletionException(error);
                }
                try {
                    return this.doRetry(target, attempt + 1, stopwatch, error);
                }
                catch (CompletionException ce) {
                    throw ce;
                }
                catch (Exception any) {
                    throw new CompletionException(any);
                }
            });
        }
        catch (Throwable th) {
            if (this.shouldAbortRetrying(th)) {
                return this.erroneousResult(th);
            }
            return this.doRetry(target, attempt + 1, stopwatch, th);
        }
    }

    private CompletionStage<V> erroneousResult(Throwable latestFailure) {
        CompletableFuture result = new CompletableFuture();
        Exception error = latestFailure instanceof Exception ? (Exception)latestFailure : new FaultToleranceException(latestFailure.getMessage(), latestFailure);
        result.completeExceptionally(error);
        return result;
    }

    private void recordSuccess(int attempt) {
        if (attempt == 0) {
            this.metricsRecorder.retrySucceededNotRetried();
        } else {
            this.metricsRecorder.retrySucceededRetried();
        }
    }

    private class DelegateResultCarrier {
        final V value;
        final Throwable error;

        private DelegateResultCarrier(V value, Throwable error) {
            this.value = value;
            this.error = error;
        }
    }
}

