/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.retry;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.retry.Delay;
import io.smallrye.faulttolerance.core.stopwatch.RunningStopwatch;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

public class Retry<V>
implements FaultToleranceStrategy<V> {
    final FaultToleranceStrategy<V> delegate;
    final String description;
    final SetOfThrowables retryOn;
    final SetOfThrowables abortOn;
    final long maxRetries;
    final long maxTotalDurationInMillis;
    final Delay delayBetweenRetries;
    final Stopwatch stopwatch;
    final MetricsRecorder metricsRecorder;

    public Retry(FaultToleranceStrategy<V> delegate, String description, SetOfThrowables retryOn, SetOfThrowables abortOn, long maxRetries, long maxTotalDurationInMillis, Delay delayBetweenRetries, Stopwatch stopwatch, MetricsRecorder metricsRecorder) {
        this.delegate = Preconditions.checkNotNull(delegate, "Retry delegate must be set");
        this.description = Preconditions.checkNotNull(description, "Retry description must be set");
        this.retryOn = Preconditions.checkNotNull(retryOn, "Set of retry-on throwables must be set");
        this.abortOn = Preconditions.checkNotNull(abortOn, "Set of abort-on throwables must be set");
        this.maxRetries = maxRetries < 0L ? Long.MAX_VALUE : maxRetries;
        this.maxTotalDurationInMillis = maxTotalDurationInMillis <= 0L ? Long.MAX_VALUE : maxTotalDurationInMillis;
        this.delayBetweenRetries = Preconditions.checkNotNull(delayBetweenRetries, "Delay must be set");
        this.stopwatch = Preconditions.checkNotNull(stopwatch, "Stopwatch must be set");
        this.metricsRecorder = metricsRecorder == null ? MetricsRecorder.NO_OP : metricsRecorder;
    }

    @Override
    public V apply(InvocationContext<V> ctx) throws Exception {
        RunningStopwatch runningStopwatch = this.stopwatch.start();
        Throwable lastFailure = null;
        for (long counter = 0L; counter <= this.maxRetries && runningStopwatch.elapsedTimeInMillis() < this.maxTotalDurationInMillis; ++counter) {
            if (counter > 0L) {
                this.metricsRecorder.retryRetried();
            }
            try {
                V result = this.delegate.apply(ctx);
                if (counter == 0L) {
                    this.metricsRecorder.retrySucceededNotRetried();
                } else {
                    this.metricsRecorder.retrySucceededRetried();
                }
                return result;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable e) {
                if (Thread.interrupted()) {
                    this.metricsRecorder.retryFailed();
                    throw new InterruptedException();
                }
                if (this.shouldAbortRetrying(e)) {
                    this.metricsRecorder.retryFailed();
                    throw e;
                }
                lastFailure = e;
                try {
                    this.delayBetweenRetries.sleep();
                    continue;
                }
                catch (InterruptedException e2) {
                    this.metricsRecorder.retryFailed();
                    throw e2;
                }
                catch (Exception e3) {
                    this.metricsRecorder.retryFailed();
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    throw e3;
                }
            }
        }
        this.metricsRecorder.retryFailed();
        if (lastFailure != null) {
            if (lastFailure instanceof Exception) {
                throw (Exception)lastFailure;
            }
            throw new FaultToleranceException(lastFailure.getMessage(), lastFailure);
        }
        throw new FaultToleranceException(this.description + " reached max retries or max retry duration");
    }

    boolean shouldAbortRetrying(Throwable e) {
        return this.abortOn.includes(e.getClass()) || !this.retryOn.includes(e.getClass());
    }

    public static interface MetricsRecorder {
        public static final MetricsRecorder NO_OP = new MetricsRecorder(){

            @Override
            public void retrySucceededNotRetried() {
            }

            @Override
            public void retrySucceededRetried() {
            }

            @Override
            public void retryFailed() {
            }

            @Override
            public void retryRetried() {
            }
        };

        public void retrySucceededNotRetried();

        public void retrySucceededRetried();

        public void retryFailed();

        public void retryRetried();
    }
}

