/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutExecution;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatch;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

public class CompletionStageTimeout<V>
extends Timeout<CompletionStage<V>> {
    private final Executor executor;

    public CompletionStageTimeout(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, long timeoutInMillis, TimeoutWatcher watcher, Executor executor, Timeout.MetricsRecorder metricsRecorder) {
        super(delegate, description, timeoutInMillis, watcher, metricsRecorder);
        this.executor = executor;
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        CompletableFuture result = new CompletableFuture();
        this.executor.execute(() -> {
            CompletionStage originalResult;
            TimeoutExecution timeoutExecution = new TimeoutExecution(Thread.currentThread(), this.timeoutInMillis, () -> result.completeExceptionally((Throwable)CompletionStageTimeout.timeoutException(this.description)));
            TimeoutWatch watch = this.watcher.schedule(timeoutExecution);
            try {
                originalResult = (CompletionStage)this.delegate.apply(ctx);
            }
            catch (Exception e) {
                timeoutExecution.finish(watch::cancel);
                if (!result.isDone()) {
                    result.completeExceptionally((Throwable)(timeoutExecution.hasTimedOut() ? CompletionStageTimeout.timeoutException(this.description) : e));
                }
                return;
            }
            if (result.isDone()) {
                return;
            }
            originalResult.whenComplete((value, exception) -> {
                timeoutExecution.finish(watch::cancel);
                if (timeoutExecution.hasTimedOut()) {
                    result.completeExceptionally((Throwable)CompletionStageTimeout.timeoutException(this.description));
                } else if (exception != null) {
                    result.completeExceptionally((Throwable)exception);
                } else {
                    result.complete(value);
                }
            });
        });
        return result;
    }
}

