/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.retry;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.retry.Delay;
import io.smallrye.faulttolerance.core.retry.Retry;
import io.smallrye.faulttolerance.core.stopwatch.RunningStopwatch;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

public class CompletionStageRetry<V>
extends Retry<CompletionStage<V>> {
    public CompletionStageRetry(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, SetOfThrowables retryOn, SetOfThrowables abortOn, long maxRetries, long maxTotalDurationInMillis, Delay delayBetweenRetries, Stopwatch stopwatch, Retry.MetricsRecorder metricsRecorder) {
        super(delegate, description, retryOn, abortOn, maxRetries, maxTotalDurationInMillis, delayBetweenRetries, stopwatch, metricsRecorder);
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        RunningStopwatch runningStopwatch = this.stopwatch.start();
        return this.doRetry(ctx, 0, runningStopwatch, null);
    }

    public CompletionStage<V> doRetry(InvocationContext<CompletionStage<V>> target, int attempt, RunningStopwatch stopwatch, Throwable latestFailure) {
        if (attempt != 0) {
            if ((long)attempt <= this.maxRetries) {
                this.metricsRecorder.retryRetried();
                try {
                    this.delayBetweenRetries.sleep();
                }
                catch (InterruptedException e) {
                    this.metricsRecorder.retryFailed();
                    return CompletionStages.failedStage(e);
                }
                catch (Exception e) {
                    this.metricsRecorder.retryFailed();
                    if (Thread.interrupted()) {
                        return CompletionStages.failedStage(new InterruptedException());
                    }
                    return CompletionStages.failedStage(e);
                }
            } else {
                this.metricsRecorder.retryFailed();
                return CompletionStages.failedStage(latestFailure);
            }
        }
        if (stopwatch.elapsedTimeInMillis() > this.maxTotalDurationInMillis) {
            if (latestFailure != null) {
                this.metricsRecorder.retryFailed();
                return CompletionStages.failedStage(latestFailure);
            }
            this.metricsRecorder.retryFailed();
            return CompletionStages.failedStage((Throwable)new FaultToleranceException(this.description + " reached max retries or max retry duration"));
        }
        try {
            CompletableFuture result = new CompletableFuture();
            this.delegate.apply(target).whenComplete((value, exception) -> {
                if (exception == null) {
                    if (attempt == 0) {
                        this.metricsRecorder.retrySucceededNotRetried();
                    } else {
                        this.metricsRecorder.retrySucceededRetried();
                    }
                    result.complete(value);
                } else {
                    this.metricsRecorder.retryFailed();
                    if (this.shouldAbortRetrying((Throwable)exception)) {
                        this.metricsRecorder.retryFailed();
                        result.completeExceptionally((Throwable)exception);
                    } else {
                        CompletionStages.propagateCompletion(this.doRetry(target, attempt + 1, stopwatch, (Throwable)exception), result);
                    }
                }
            });
            return result;
        }
        catch (Throwable e) {
            if (this.shouldAbortRetrying(e)) {
                return CompletionStages.failedStage(e);
            }
            return this.doRetry(target, attempt + 1, stopwatch, e);
        }
    }
}

