/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.timeout.TimeoutExecution;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatch;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorTimeoutWatcher
implements TimeoutWatcher {
    private final ScheduledExecutorService executor;

    public ScheduledExecutorTimeoutWatcher(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public TimeoutWatch schedule(TimeoutExecution execution) {
        final ScheduledFuture<?> future = this.executor.schedule(execution::timeoutAndInterrupt, execution.timeoutInMillis(), TimeUnit.MILLISECONDS);
        return new TimeoutWatch(){

            @Override
            public boolean isRunning() {
                return !future.isDone();
            }

            @Override
            public void cancel() {
                future.cancel(true);
            }
        };
    }
}

