package io.smallrye.faulttolerance.core.timer;

import java.util.Locale;
import java.io.Serializable;
import io.smallrye.faulttolerance.core.timer.TimerTask;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class TimerLogger_$logger extends DelegatingBasicLogger implements TimerLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = TimerLogger_$logger.class.getName();
    public TimerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void createdTimer(final String name) {
        super.log.logf(FQCN, TRACE, null, createdTimer$str(), name);
    }
    protected String createdTimer$str() {
        return "Timer %s created";
    }
    @Override
    public final void shutdownTimer(final String name) {
        super.log.logf(FQCN, TRACE, null, shutdownTimer$str(), name);
    }
    protected String shutdownTimer$str() {
        return "Timer %s shut down";
    }
    @Override
    public final void scheduledTimerTask(final io.smallrye.faulttolerance.core.timer.TimerTask task, final long millis) {
        if (super.log.isEnabled(TRACE)) {
            final int taskHashCode;
            if (task == null) taskHashCode = 0; else taskHashCode = System.identityHashCode(task);
            super.log.logf(FQCN, TRACE, null, scheduledTimerTask$str(), taskHashCode, millis);
        }
    }
    protected String scheduledTimerTask$str() {
        return "Scheduled timer task %s to run in %s millis";
    }
    @Override
    public final void runningTimerTask(final io.smallrye.faulttolerance.core.timer.TimerTask task) {
        if (super.log.isEnabled(TRACE)) {
            final int taskHashCode;
            if (task == null) taskHashCode = 0; else taskHashCode = System.identityHashCode(task);
            super.log.logf(FQCN, TRACE, null, runningTimerTask$str(), taskHashCode);
        }
    }
    protected String runningTimerTask$str() {
        return "Running timer task %s";
    }
    @Override
    public final void cancelledTimerTask(final io.smallrye.faulttolerance.core.timer.TimerTask task) {
        if (super.log.isEnabled(TRACE)) {
            final int taskHashCode;
            if (task == null) taskHashCode = 0; else taskHashCode = System.identityHashCode(task);
            super.log.logf(FQCN, TRACE, null, cancelledTimerTask$str(), taskHashCode);
        }
    }
    protected String cancelledTimerTask$str() {
        return "Cancelled timer task %s";
    }
    @Override
    public final void unexpectedExceptionInTimerLoop(final Exception e) {
        super.log.logf(FQCN, WARN, e, unexpectedExceptionInTimerLoop$str());
    }
    protected String unexpectedExceptionInTimerLoop$str() {
        return "SRFTL11000: Unexpected exception in timer loop, ignoring";
    }
}
