/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.apiimpl;

import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadEvents;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.retry.RetryEvents;
import io.smallrye.faulttolerance.core.timeout.TimeoutEvents;
import io.smallrye.faulttolerance.core.util.Callbacks;
import java.util.function.Consumer;

final class EventHandlers {
    private final Runnable bulkheadOnAccepted;
    private final Runnable bulkheadOnRejected;
    private final Runnable bulkheadOnFinished;
    private final Consumer<CircuitBreakerEvents.StateTransition> cbMaintenanceEventHandler;
    private final Consumer<CircuitBreakerState> circuitBreakerOnStateChange;
    private final Runnable circuitBreakerOnSuccess;
    private final Runnable circuitBreakerOnFailure;
    private final Runnable circuitBreakerOnPrevented;
    private final Runnable retryOnRetry;
    private final Runnable retryOnSuccess;
    private final Runnable retryOnFailure;
    private final Runnable timeoutOnTimeout;
    private final Runnable timeoutOnFinished;

    EventHandlers(Runnable bulkheadOnAccepted, Runnable bulkheadOnRejected, Runnable bulkheadOnFinished, Consumer<CircuitBreakerEvents.StateTransition> cbMaintenanceEventHandler, Consumer<CircuitBreakerState> circuitBreakerOnStateChange, Runnable circuitBreakerOnSuccess, Runnable circuitBreakerOnFailure, Runnable circuitBreakerOnPrevented, Runnable retryOnRetry, Runnable retryOnSuccess, Runnable retryOnFailure, Runnable timeoutOnTimeout, Runnable timeoutOnFinished) {
        this.bulkheadOnAccepted = Callbacks.wrap(bulkheadOnAccepted);
        this.bulkheadOnRejected = Callbacks.wrap(bulkheadOnRejected);
        this.bulkheadOnFinished = Callbacks.wrap(bulkheadOnFinished);
        this.cbMaintenanceEventHandler = Callbacks.wrap(cbMaintenanceEventHandler);
        this.circuitBreakerOnStateChange = Callbacks.wrap(circuitBreakerOnStateChange);
        this.circuitBreakerOnSuccess = Callbacks.wrap(circuitBreakerOnSuccess);
        this.circuitBreakerOnFailure = Callbacks.wrap(circuitBreakerOnFailure);
        this.circuitBreakerOnPrevented = Callbacks.wrap(circuitBreakerOnPrevented);
        this.retryOnRetry = Callbacks.wrap(retryOnRetry);
        this.retryOnSuccess = Callbacks.wrap(retryOnSuccess);
        this.retryOnFailure = Callbacks.wrap(retryOnFailure);
        this.timeoutOnTimeout = Callbacks.wrap(timeoutOnTimeout);
        this.timeoutOnFinished = Callbacks.wrap(timeoutOnFinished);
    }

    void register(InvocationContext<?> ctx) {
        if (this.bulkheadOnAccepted != null || this.bulkheadOnRejected != null) {
            ctx.registerEventHandler(BulkheadEvents.DecisionMade.class, event -> {
                if (event.accepted) {
                    if (this.bulkheadOnAccepted != null) {
                        this.bulkheadOnAccepted.run();
                    }
                } else if (this.bulkheadOnRejected != null) {
                    this.bulkheadOnRejected.run();
                }
            });
        }
        if (this.bulkheadOnFinished != null) {
            ctx.registerEventHandler(BulkheadEvents.FinishedRunning.class, event -> this.bulkheadOnFinished.run());
        }
        if (this.cbMaintenanceEventHandler != null) {
            ctx.registerEventHandler(CircuitBreakerEvents.StateTransition.class, this.cbMaintenanceEventHandler);
        }
        if (this.circuitBreakerOnStateChange != null) {
            ctx.registerEventHandler(CircuitBreakerEvents.StateTransition.class, event -> {
                CircuitBreakerState targetState = event.targetState;
                this.circuitBreakerOnStateChange.accept(targetState);
            });
        }
        if (this.circuitBreakerOnSuccess != null || this.circuitBreakerOnFailure != null || this.circuitBreakerOnPrevented != null) {
            ctx.registerEventHandler(CircuitBreakerEvents.Finished.class, event -> {
                switch (event.result) {
                    case SUCCESS: {
                        if (this.circuitBreakerOnSuccess == null) break;
                        this.circuitBreakerOnSuccess.run();
                        break;
                    }
                    case FAILURE: {
                        if (this.circuitBreakerOnFailure == null) break;
                        this.circuitBreakerOnFailure.run();
                        break;
                    }
                    case PREVENTED: {
                        if (this.circuitBreakerOnPrevented == null) break;
                        this.circuitBreakerOnPrevented.run();
                    }
                }
            });
        }
        if (this.retryOnRetry != null) {
            ctx.registerEventHandler(RetryEvents.Retried.class, event -> this.retryOnRetry.run());
        }
        if (this.retryOnSuccess != null || this.retryOnFailure != null) {
            ctx.registerEventHandler(RetryEvents.Finished.class, event -> {
                if (event.result == RetryEvents.Result.VALUE_RETURNED) {
                    if (this.retryOnSuccess != null) {
                        this.retryOnSuccess.run();
                    }
                } else if (this.retryOnFailure != null) {
                    this.retryOnFailure.run();
                }
            });
        }
        if (this.timeoutOnTimeout != null || this.timeoutOnFinished != null) {
            ctx.registerEventHandler(TimeoutEvents.Finished.class, event -> {
                if (event.timedOut) {
                    if (this.timeoutOnTimeout != null) {
                        this.timeoutOnTimeout.run();
                    }
                } else if (this.timeoutOnFinished != null) {
                    this.timeoutOnFinished.run();
                }
            });
        }
    }
}

