package io.smallrye.faulttolerance.core.event.loop;

import java.util.Locale;
import java.io.Serializable;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class EventLoopLogger_$logger extends DelegatingBasicLogger implements EventLoopLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EventLoopLogger_$logger.class.getName();
    public EventLoopLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void foundEventLoop(final io.smallrye.faulttolerance.core.event.loop.EventLoop eventLoop) {
        if (super.log.isEnabled(DEBUG)) {
            final Class<?> eventLoopClass;
            if (eventLoop == null) {
                eventLoopClass = null;
            } else eventLoopClass = eventLoop.getClass();
            super.log.logf(FQCN, DEBUG, null, foundEventLoop$str(), eventLoopClass);
        }
    }
    protected String foundEventLoop$str() {
        return "Found event loop integration %s";
    }
    @Override
    public final void noEventLoop() {
        super.log.logf(FQCN, DEBUG, null, noEventLoop$str());
    }
    protected String noEventLoop$str() {
        return "No event loop integration found";
    }
}
