/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.timeout.AsyncTimeoutNotification;
import io.smallrye.faulttolerance.core.timeout.TimeoutEvents;
import io.smallrye.faulttolerance.core.timeout.TimeoutExecution;
import io.smallrye.faulttolerance.core.timeout.TimeoutLogger;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.core.timer.TimerTask;
import io.smallrye.faulttolerance.core.util.Preconditions;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

public class Timeout<V>
implements FaultToleranceStrategy<V> {
    final FaultToleranceStrategy<V> delegate;
    final String description;
    final long timeoutInMillis;
    final Timer timer;

    public Timeout(FaultToleranceStrategy<V> delegate, String description, long timeoutInMillis, Timer timer) {
        this.delegate = Preconditions.checkNotNull(delegate, "Timeout delegate must be set");
        this.description = Preconditions.checkNotNull(description, "Timeout description must be set");
        this.timeoutInMillis = Preconditions.check(timeoutInMillis, timeoutInMillis > 0L, "Timeout must be > 0");
        this.timer = Preconditions.checkNotNull(timer, "Timer must be set");
    }

    @Override
    public V apply(InvocationContext<V> ctx) throws Exception {
        TimeoutLogger.LOG.trace("Timeout started");
        try {
            V v = this.doApply(ctx);
            return v;
        }
        finally {
            TimeoutLogger.LOG.trace("Timeout finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V doApply(InvocationContext<V> ctx) throws Exception {
        AsyncTimeoutNotification notification = ctx.get(AsyncTimeoutNotification.class);
        ctx.remove(AsyncTimeoutNotification.class);
        TimeoutExecution execution = new TimeoutExecution(Thread.currentThread(), this.timeoutInMillis, () -> {
            if (notification != null) {
                notification.accept(Timeout.timeoutException(this.description));
            }
        });
        TimerTask task = this.timer.schedule(execution.timeoutInMillis(), execution::timeoutAndInterrupt);
        ctx.fireEvent(TimeoutEvents.Started.INSTANCE);
        V result = null;
        Exception exception = null;
        boolean interrupted = false;
        try {
            result = this.delegate.apply(ctx);
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            execution.finish(task::cancel);
        }
        if (Thread.interrupted()) {
            interrupted = true;
        }
        if (interrupted && !execution.hasTimedOut()) {
            exception = new InterruptedException();
        }
        if (execution.hasTimedOut()) {
            TimeoutLogger.LOG.debugf("%s invocation timed out (%d ms)", this.description, this.timeoutInMillis);
            ctx.fireEvent(TimeoutEvents.Finished.TIMED_OUT);
            throw Timeout.timeoutException(this.description);
        }
        ctx.fireEvent(TimeoutEvents.Finished.NORMALLY);
        if (exception != null) {
            throw exception;
        }
        return result;
    }

    static TimeoutException timeoutException(String description) {
        return new TimeoutException(description + " timed out");
    }
}

