/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.metrics;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.metrics.CompletionStageMetricsCollector;
import io.smallrye.faulttolerance.core.metrics.DelegatingMeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MeteredOperationName;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DelegatingCompletionStageMetricsCollector<V>
implements FaultToleranceStrategy<CompletionStage<V>> {
    private final FaultToleranceStrategy<CompletionStage<V>> delegate;
    private final MetricsProvider provider;
    private final MeteredOperation originalOperation;
    private final ConcurrentMap<MeteredOperation, CompletionStageMetricsCollector<V>> cache = new ConcurrentHashMap<MeteredOperation, CompletionStageMetricsCollector<V>>();

    public DelegatingCompletionStageMetricsCollector(FaultToleranceStrategy<CompletionStage<V>> delegate, MetricsProvider provider, MeteredOperation originalOperation) {
        this.delegate = delegate;
        this.provider = provider;
        this.originalOperation = originalOperation;
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) throws Exception {
        MeteredOperationName name = ctx.get(MeteredOperationName.class);
        MeteredOperation operation = name != null ? new DelegatingMeteredOperation(this.originalOperation, name.get()) : this.originalOperation;
        CompletionStageMetricsCollector delegate = this.cache.computeIfAbsent(operation, ignored -> new CompletionStageMetricsCollector<V>(this.delegate, this.provider.create(operation), operation));
        return delegate.apply((InvocationContext)ctx);
    }
}

