/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core;

import io.smallrye.faulttolerance.core.FaultToleranceEvent;
import io.smallrye.faulttolerance.core.Future;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class FaultToleranceContext<V> {
    private final Supplier<Future<V>> delegate;
    private final boolean isAsync;
    private final ConcurrentMap<Class<?>, Object> data = new ConcurrentHashMap(4);
    private final ConcurrentMap<Class<? extends FaultToleranceEvent>, Collection<Consumer<? extends FaultToleranceEvent>>> eventHandlers = new ConcurrentHashMap<Class<? extends FaultToleranceEvent>, Collection<Consumer<? extends FaultToleranceEvent>>>();

    public FaultToleranceContext(Supplier<Future<V>> delegate, boolean isAsync) {
        this.delegate = delegate;
        this.isAsync = isAsync;
    }

    public Future<V> call() {
        return this.delegate.get();
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public boolean isSync() {
        return !this.isAsync;
    }

    public <T> void set(Class<T> clazz, T object) {
        this.data.put(clazz, object);
    }

    public <T> T remove(Class<T> clazz) {
        return clazz.cast(this.data.remove(clazz));
    }

    public <T> T get(Class<T> clazz) {
        return clazz.cast(this.data.get(clazz));
    }

    public <T> T get(Class<T> clazz, T defaultValue) {
        T value = this.get(clazz);
        return value != null ? value : defaultValue;
    }

    public <E extends FaultToleranceEvent> void registerEventHandler(Class<E> eventType, Consumer<E> handler) {
        this.eventHandlers.computeIfAbsent(eventType, ignored -> new ConcurrentLinkedQueue()).add(handler);
    }

    public <E extends FaultToleranceEvent> void fireEvent(E event) {
        Collection handlers = (Collection)this.eventHandlers.get(event.getClass());
        if (handlers != null) {
            Iterator iterator = handlers.iterator();
            while (iterator.hasNext()) {
                Consumer handler;
                Consumer consumer = handler = (Consumer)iterator.next();
                consumer.accept(event);
            }
        }
    }
}

