/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.apiimpl;

import io.smallrye.faulttolerance.api.FaultTolerance;
import io.smallrye.faulttolerance.core.apiimpl.FaultToleranceImpl;
import io.smallrye.faulttolerance.core.metrics.MeteredOperationName;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class LazyFaultTolerance<T>
implements FaultTolerance<T> {
    private final Supplier<FaultToleranceImpl<?, T>> builder;
    private final Class<?> asyncType;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile FaultToleranceImpl<?, T> instance;

    LazyFaultTolerance(Supplier<FaultToleranceImpl<?, T>> builder, Class<?> asyncType) {
        this.builder = builder;
        this.asyncType = asyncType;
    }

    public Class<?> internalGetAsyncType() {
        return this.asyncType;
    }

    public T call(Callable<T> action, MeteredOperationName meteredOperationName) throws Exception {
        return this.instance().call(action, meteredOperationName);
    }

    public T call(Callable<T> action) throws Exception {
        return this.instance().call(action);
    }

    public T get(Supplier<T> action) {
        return (T)this.instance().get(action);
    }

    public void run(Runnable action) {
        this.instance().run(action);
    }

    public <U> FaultTolerance<U> cast() {
        return this.instance().cast();
    }

    public <U> FaultTolerance<U> castAsync(Class<?> asyncType) {
        return this.instance().castAsync(asyncType);
    }

    private FaultToleranceImpl<?, T> instance() {
        FaultToleranceImpl<?, T> instance = this.instance;
        if (instance == null) {
            this.lock.lock();
            try {
                instance = this.instance;
                if (instance == null) {
                    this.instance = instance = this.builder.get();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return instance;
    }
}

