/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.apiimpl;

import io.smallrye.faulttolerance.api.TypedGuard;
import io.smallrye.faulttolerance.core.apiimpl.TypedGuardImpl;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class LazyTypedGuard<V, T>
implements TypedGuard<T> {
    private final Supplier<TypedGuardImpl<V, T>> builder;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile TypedGuardImpl<V, T> instance;

    LazyTypedGuard(Supplier<TypedGuardImpl<V, T>> builder) {
        this.builder = builder;
    }

    public T call(Callable<T> action) throws Exception {
        return this.instance().call(action);
    }

    public T get(Supplier<T> action) {
        return this.instance().get(action);
    }

    public TypedGuardImpl<V, T> instance() {
        TypedGuardImpl<V, T> instance = this.instance;
        if (instance == null) {
            this.lock.lock();
            try {
                instance = this.instance;
                if (instance == null) {
                    this.instance = instance = this.builder.get();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return instance;
    }
}

