/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.metrics;

import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.metrics.DelegatingMeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MeteredOperationName;
import io.smallrye.faulttolerance.core.metrics.MetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DelegatingMetricsCollector<V>
implements FaultToleranceStrategy<V> {
    private final FaultToleranceStrategy<V> delegate;
    private final MetricsProvider provider;
    private final MeteredOperation originalOperation;
    private final ConcurrentMap<MeteredOperation, MetricsCollector<V>> cache = new ConcurrentHashMap<MeteredOperation, MetricsCollector<V>>();

    public DelegatingMetricsCollector(FaultToleranceStrategy<V> delegate, MetricsProvider provider, MeteredOperation originalOperation) {
        this.delegate = delegate;
        this.provider = provider;
        this.originalOperation = originalOperation;
    }

    @Override
    public Future<V> apply(FaultToleranceContext<V> ctx) {
        MeteredOperationName name = ctx.get(MeteredOperationName.class);
        MeteredOperation operation = name != null ? new DelegatingMeteredOperation(this.originalOperation, name.get()) : this.originalOperation;
        MetricsCollector delegate = this.cache.computeIfAbsent(operation, ignored -> new MetricsCollector<V>(this.delegate, this.provider.create(operation), operation));
        return delegate.apply(ctx);
    }
}

