/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.config.GenericConfig;
import java.lang.reflect.Method;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;
import org.jboss.logging.Logger;

public class CircuitBreakerConfig
extends GenericConfig<CircuitBreaker> {
    public static final String DELAY = "delay";
    public static final String DELAY_UNIT = "delayUnit";
    public static final String FAIL_ON = "failOn";
    public static final String FAILURE_RATIO = "failureRatio";
    public static final String REQUEST_VOLUME_THRESHOLD = "requestVolumeThreshold";
    public static final String SUCCESS_THRESHOLD = "successThreshold";
    public static final String SYNCHRONOUS_STATE_VALIDATION = "synchronousStateValidation";
    private static final Logger LOGGER = Logger.getLogger(CircuitBreakerConfig.class);
    private static final String INVALID_CIRCUIT_BREAKER_ON = "Invalid CircuitBreaker on ";
    private static Map<String, Class<?>> keys2Type = CircuitBreakerConfig.initKeys();

    public CircuitBreakerConfig(Method method) {
        super(CircuitBreaker.class, method);
    }

    public CircuitBreakerConfig(AnnotatedMethod<?> annotatedMethod) {
        super(CircuitBreaker.class, annotatedMethod);
    }

    @Override
    public void validate() {
        if (this.get(DELAY, Long.class) < 0L) {
            throw new FaultToleranceDefinitionException(INVALID_CIRCUIT_BREAKER_ON + this.getMethodInfo() + " : delay shouldn't be lower than 0");
        }
        if (this.get(REQUEST_VOLUME_THRESHOLD, Integer.class) < 1) {
            throw new FaultToleranceDefinitionException(INVALID_CIRCUIT_BREAKER_ON + this.getMethodInfo() + " : requestVolumeThreshold shouldn't be lower than 1");
        }
        if (this.get(FAILURE_RATIO, Double.class) < 0.0 || this.get(FAILURE_RATIO, Double.class) > 1.0) {
            throw new FaultToleranceDefinitionException(INVALID_CIRCUIT_BREAKER_ON + this.getMethodInfo() + " : failureRation should be between 0 and 1");
        }
        int successThreshold = this.get(SUCCESS_THRESHOLD, Integer.class);
        if (successThreshold < 1) {
            throw new FaultToleranceDefinitionException(INVALID_CIRCUIT_BREAKER_ON + this.getMethodInfo() + " : successThreshold shouldn't be lower than 1");
        }
        if (!CircuitBreakerConfig.getConfig().getOptionalValue("org_wildfly_swarm_microprofile_faulttolerance_syncCircuitBreaker", Boolean.class).orElse(true).booleanValue() && successThreshold > 1) {
            LOGGER.warnf("Synchronous circuit breaker disabled - successThreshold of value greater than 1 is not supported: " + this.getMethodInfo(), new Object[0]);
        }
    }

    @Override
    protected Class<CircuitBreaker> getConfigType() {
        return CircuitBreaker.class;
    }

    @Override
    protected Map<String, Class<?>> getKeysToType() {
        return keys2Type;
    }

    private static Map<String, Class<?>> initKeys() {
        HashMap<String, Class> keys = new HashMap<String, Class>();
        keys.put(DELAY, Long.class);
        keys.put(DELAY_UNIT, ChronoUnit.class);
        keys.put(FAIL_ON, Class[].class);
        keys.put(FAILURE_RATIO, Double.class);
        keys.put(REQUEST_VOLUME_THRESHOLD, Integer.class);
        keys.put(SUCCESS_THRESHOLD, Integer.class);
        keys.put(SYNCHRONOUS_STATE_VALIDATION, Boolean.class);
        return Collections.unmodifiableMap(keys);
    }
}

