/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.config.BulkheadConfig;
import io.smallrye.faulttolerance.config.CircuitBreakerConfig;
import io.smallrye.faulttolerance.config.FallbackConfig;
import io.smallrye.faulttolerance.config.GenericConfig;
import io.smallrye.faulttolerance.config.RetryConfig;
import io.smallrye.faulttolerance.config.TimeoutConfig;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class FaultToleranceOperation {
    private final Method method;
    private final boolean async;
    private final BulkheadConfig bulkhead;
    private final CircuitBreakerConfig circuitBreaker;
    private final FallbackConfig fallback;
    private final RetryConfig retry;
    private final TimeoutConfig timeout;

    public static FaultToleranceOperation of(AnnotatedMethod<?> annotatedMethod) {
        return new FaultToleranceOperation(annotatedMethod.getJavaMember(), FaultToleranceOperation.isAnnotated(Asynchronous.class, annotatedMethod), FaultToleranceOperation.getConfig(Bulkhead.class, annotatedMethod, BulkheadConfig::new), FaultToleranceOperation.getConfig(CircuitBreaker.class, annotatedMethod, CircuitBreakerConfig::new), FaultToleranceOperation.getConfig(Fallback.class, annotatedMethod, FallbackConfig::new), FaultToleranceOperation.getConfig(Retry.class, annotatedMethod, RetryConfig::new), FaultToleranceOperation.getConfig(Timeout.class, annotatedMethod, TimeoutConfig::new));
    }

    public static FaultToleranceOperation of(Method method) {
        return new FaultToleranceOperation(method, FaultToleranceOperation.isAnnotated(Asynchronous.class, method), FaultToleranceOperation.getConfig(Bulkhead.class, method, BulkheadConfig::new), FaultToleranceOperation.getConfig(CircuitBreaker.class, method, CircuitBreakerConfig::new), FaultToleranceOperation.getConfig(Fallback.class, method, FallbackConfig::new), FaultToleranceOperation.getConfig(Retry.class, method, RetryConfig::new), FaultToleranceOperation.getConfig(Timeout.class, method, TimeoutConfig::new));
    }

    private FaultToleranceOperation(Method method, boolean async, BulkheadConfig bulkhead, CircuitBreakerConfig circuitBreaker, FallbackConfig fallback, RetryConfig retry, TimeoutConfig timeout) {
        this.method = method;
        this.async = async;
        this.bulkhead = bulkhead;
        this.circuitBreaker = circuitBreaker;
        this.fallback = fallback;
        this.retry = retry;
        this.timeout = timeout;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean hasBulkhead() {
        return this.bulkhead != null;
    }

    public BulkheadConfig getBulkhead() {
        return this.bulkhead;
    }

    public CircuitBreakerConfig getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public boolean hasCircuitBreaker() {
        return this.circuitBreaker != null;
    }

    public FallbackConfig getFallback() {
        return this.fallback;
    }

    public boolean hasFallback() {
        return this.fallback != null;
    }

    public RetryConfig getRetry() {
        return this.retry;
    }

    public boolean hasRetry() {
        return this.retry != null;
    }

    public TimeoutConfig getTimeout() {
        return this.timeout;
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isLegitimate() {
        return this.async || this.bulkhead != null || this.circuitBreaker != null || this.fallback != null || this.retry != null || this.timeout != null;
    }

    public boolean validate() {
        if (this.async && !Future.class.equals(this.method.getReturnType())) {
            throw new FaultToleranceDefinitionException("Invalid @Asynchronous on " + this.method + " : the return type must be java.util.concurrent.Future");
        }
        if (this.bulkhead != null) {
            this.bulkhead.validate();
        }
        if (this.circuitBreaker != null) {
            this.circuitBreaker.validate();
        }
        if (this.fallback != null) {
            this.fallback.validate();
        }
        if (this.retry != null) {
            this.retry.validate();
        }
        if (this.timeout != null) {
            this.timeout.validate();
        }
        return true;
    }

    public String toString() {
        return "FaultToleranceOperation [method=" + this.method.toGenericString() + "]";
    }

    private static <A extends Annotation, C extends GenericConfig<A>> C getConfig(Class<A> annotationType, AnnotatedMethod<?> annotatedMethod, Function<AnnotatedMethod<?>, C> function) {
        if (FaultToleranceOperation.isAnnotated(annotationType, annotatedMethod)) {
            return (C)((GenericConfig)function.apply(annotatedMethod));
        }
        return null;
    }

    private static <A extends Annotation> boolean isAnnotated(Class<A> annotationType, AnnotatedMethod<?> annotatedMethod) {
        return annotatedMethod.isAnnotationPresent(annotationType) || annotatedMethod.getDeclaringType().isAnnotationPresent(annotationType);
    }

    private static <A extends Annotation, C extends GenericConfig<A>> C getConfig(Class<A> annotationType, Method method, Function<Method, C> function) {
        if (FaultToleranceOperation.isAnnotated(annotationType, method)) {
            return (C)((GenericConfig)function.apply(method));
        }
        return null;
    }

    private static <A extends Annotation> boolean isAnnotated(Class<A> annotationType, Method method) {
        return method.isAnnotationPresent(annotationType) || method.getDeclaringClass().isAnnotationPresent(annotationType);
    }
}

