/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import io.smallrye.faulttolerance.SimpleCommand;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class CompositeCommand
extends HystrixCommand<Object> {
    private final Callable<Object> callable;

    public static Future<Object> createAndQueue(Callable<Object> callable, FaultToleranceOperation operation) {
        return new CompositeCommand(callable, operation).queue();
    }

    protected CompositeCommand(Callable<Object> callable, FaultToleranceOperation operation) {
        super(CompositeCommand.initSetter(operation));
        this.callable = callable;
    }

    protected Object run() throws Exception {
        return this.callable.call();
    }

    private static HystrixCommand.Setter initSetter(FaultToleranceOperation operation) {
        HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter();
        HystrixCommandKey commandKey = HystrixCommandKey.Factory.asKey((String)(CompositeCommand.class.getSimpleName() + "#" + SimpleCommand.getCommandKey(operation.getMethod())));
        properties.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
        properties.withFallbackEnabled(false);
        properties.withCircuitBreakerEnabled(false);
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"CompositeCommandGroup")).andCommandKey(commandKey).andCommandPropertiesDefaults(properties);
        setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)commandKey.name()));
        HystrixThreadPoolProperties.Setter threadPoolSetter = HystrixThreadPoolProperties.Setter();
        threadPoolSetter.withAllowMaximumSizeToDivergeFromCoreSize(true);
        setter.andThreadPoolPropertiesDefaults(threadPoolSetter);
        return setter;
    }
}

