/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.FaultToleranceOperationProvider;
import io.smallrye.faulttolerance.HystrixExtension;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.lang.reflect.Method;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;

@Dependent
public class DefaultFaultToleranceOperationProvider
implements FaultToleranceOperationProvider {
    private final HystrixExtension extension;

    @Inject
    public DefaultFaultToleranceOperationProvider(BeanManager beanManager) {
        this.extension = (HystrixExtension)beanManager.getExtension(HystrixExtension.class);
    }

    @Override
    public FaultToleranceOperation apply(Method method) {
        String methodKey = method.toGenericString();
        FaultToleranceOperation operation = null;
        if (this.extension != null) {
            operation = this.extension.getFaultToleranceOperation(methodKey);
        }
        if (operation == null) {
            operation = FaultToleranceOperation.of(method);
            operation.validate();
        }
        return operation;
    }
}

