/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import io.smallrye.faulttolerance.CommandListener;
import io.smallrye.faulttolerance.CompositeCommand;
import io.smallrye.faulttolerance.DefaultMethodFallbackProvider;
import io.smallrye.faulttolerance.ExecutionContextWithInvocationContext;
import io.smallrye.faulttolerance.FailureNotHandledException;
import io.smallrye.faulttolerance.FallbackHandlerProvider;
import io.smallrye.faulttolerance.FaultToleranceOperationProvider;
import io.smallrye.faulttolerance.HystrixCommandBinding;
import io.smallrye.faulttolerance.RetryContext;
import io.smallrye.faulttolerance.SecurityActions;
import io.smallrye.faulttolerance.SimpleCommand;
import io.smallrye.faulttolerance.SynchronousCircuitBreaker;
import io.smallrye.faulttolerance.config.BulkheadConfig;
import io.smallrye.faulttolerance.config.FallbackConfig;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.jboss.logging.Logger;

@Interceptor
@HystrixCommandBinding
@Priority(value=3001)
public class HystrixCommandInterceptor {
    public static final String SYNC_CIRCUIT_BREAKER_KEY = "io_smallrye_faulttolerance_syncCircuitBreaker";
    private static final Logger LOGGER = Logger.getLogger(HystrixCommandInterceptor.class);
    private final ConcurrentMap<String, HystrixCircuitBreaker> circuitBreakers;
    private final ConcurrentMap<Method, CommandMetadata> commandMetadataCache;
    private final Boolean nonFallBackEnable;
    private final Boolean syncCircuitBreakerEnabled;
    private final FallbackHandlerProvider fallbackHandlerProvider;
    private final FaultToleranceOperationProvider faultToleranceOperationProvider;
    private final Instance<CommandListener> listeners;
    private final Bean<?> interceptedBean;

    @Inject
    public HystrixCommandInterceptor(@ConfigProperty(name="MP_Fault_Tolerance_NonFallback_Enabled", defaultValue="true") Boolean nonFallBackEnable, Config config, FallbackHandlerProvider fallbackHandlerProvider, FaultToleranceOperationProvider faultToleranceOperationProvider, Instance<CommandListener> listeners, @Intercepted Bean<?> interceptedBean) {
        this.nonFallBackEnable = nonFallBackEnable;
        this.syncCircuitBreakerEnabled = config.getOptionalValue(SYNC_CIRCUIT_BREAKER_KEY, Boolean.class).orElse(true);
        this.fallbackHandlerProvider = fallbackHandlerProvider;
        this.faultToleranceOperationProvider = faultToleranceOperationProvider;
        this.commandMetadataCache = new ConcurrentHashMap<Method, CommandMetadata>();
        this.listeners = listeners;
        this.interceptedBean = interceptedBean;
        try {
            Field field = SecurityActions.getDeclaredField(HystrixCircuitBreaker.Factory.class, "circuitBreakersByCommand");
            SecurityActions.setAccessible(field);
            this.circuitBreakers = (ConcurrentHashMap)field.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not obtain reference to com.netflix.hystrix.HystrixCircuitBreaker.Factory.circuitBreakersByCommand", e);
        }
    }

    @AroundInvoke
    public Object interceptCommand(InvocationContext invocationContext) throws Exception {
        Class<?> beanClass;
        Method method = invocationContext.getMethod();
        CommandMetadata metadata = this.commandMetadataCache.computeIfAbsent(method, arg_0 -> this.lambda$interceptCommand$0(beanClass = this.interceptedBean != null ? this.interceptedBean.getBeanClass() : invocationContext.getTarget().getClass(), method, arg_0));
        if (!metadata.operation.isLegitimate()) {
            return invocationContext.proceed();
        }
        ExecutionContextWithInvocationContext ctx = new ExecutionContextWithInvocationContext(invocationContext);
        LOGGER.tracef("FT operation intercepted: %s", (Object)method);
        RetryContext retryContext = this.nonFallBackEnable != false && metadata.operation.hasRetry() ? new RetryContext(metadata.operation.getRetry()) : null;
        SynchronousCircuitBreaker syncCircuitBreaker = this.getSynchronousCircuitBreaker(metadata);
        Function<Supplier<Object>, SimpleCommand> commandFactory = fallback -> new SimpleCommand(metadata.setter, ctx, (Supplier<Object>)fallback, metadata.operation, (Iterable<CommandListener>)(this.listeners.isUnsatisfied() ? null : this.listeners));
        if (metadata.operation.isAsync()) {
            LOGGER.debugf("Queue up command for async execution: %s", (Object)metadata.operation);
            return new AsyncFuture(CompositeCommand.createAndQueue(() -> this.executeCommand(commandFactory, retryContext, metadata, ctx, syncCircuitBreaker), metadata.operation));
        }
        LOGGER.debugf("Sync execution: %s]", (Object)metadata.operation);
        return this.executeCommand(commandFactory, retryContext, metadata, ctx, syncCircuitBreaker);
    }

    private Object executeCommand(Function<Supplier<Object>, SimpleCommand> commandFactory, RetryContext retryContext, CommandMetadata metadata, ExecutionContextWithInvocationContext ctx, SynchronousCircuitBreaker syncCircuitBreaker) throws Exception {
        while (true) {
            if (retryContext != null) {
                LOGGER.debugf("Executing %s with %s", (Object)metadata.operation, (Object)retryContext);
            }
            Supplier<Object> fallback = null;
            if (retryContext == null || retryContext.isLastAttempt()) {
                fallback = metadata.getFallback(ctx);
            }
            SimpleCommand command = commandFactory.apply(fallback);
            try {
                Object res = command.execute();
                if (syncCircuitBreaker != null) {
                    if (command.isFailedExecution()) {
                        syncCircuitBreaker.executionFailed();
                    } else {
                        syncCircuitBreaker.executionSucceeded();
                    }
                }
                return res;
            }
            catch (HystrixRuntimeException e) {
                Exception res;
                if ((res = HystrixCommandInterceptor.processHystrixRuntimeException(e, retryContext, metadata.operation.getMethod(), syncCircuitBreaker)) == null) continue;
                throw res;
            }
            break;
        }
    }

    private static Exception processHystrixRuntimeException(HystrixRuntimeException e, RetryContext retryContext, Method method, SynchronousCircuitBreaker syncCircuitBreaker) {
        HystrixRuntimeException.FailureType failureType = e.getFailureType();
        LOGGER.tracef("Hystrix runtime failure [%s] with cause %s when invoking %s", (Object)failureType, (Object)e.getCause(), (Object)method);
        Throwable fallbackException = e.getFallbackException();
        if (fallbackException instanceof FailureNotHandledException) {
            FailureNotHandledException failureNotHandledException = (FailureNotHandledException)fallbackException;
            return (Exception)failureNotHandledException.getCause();
        }
        if (syncCircuitBreaker != null) {
            syncCircuitBreaker.executionFailed();
        }
        switch (failureType) {
            case TIMEOUT: {
                org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException timeoutException = new org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException((Throwable)e);
                if (retryContext != null && retryContext.shouldRetry()) {
                    return retryContext.nextRetry((Throwable)timeoutException);
                }
                return timeoutException;
            }
            case SHORTCIRCUIT: {
                CircuitBreakerOpenException circuitBreakerOpenException = new CircuitBreakerOpenException(method.getName());
                if (retryContext != null && retryContext.shouldRetry()) {
                    return retryContext.nextRetry((Throwable)circuitBreakerOpenException);
                }
                return circuitBreakerOpenException;
            }
            case REJECTED_THREAD_EXECUTION: 
            case REJECTED_SEMAPHORE_EXECUTION: 
            case REJECTED_SEMAPHORE_FALLBACK: {
                BulkheadException bulkheadException = new BulkheadException((Throwable)e);
                if (retryContext != null && retryContext.shouldRetry()) {
                    return retryContext.nextRetry((Throwable)bulkheadException);
                }
                return bulkheadException;
            }
            case COMMAND_EXCEPTION: {
                if (retryContext == null || !retryContext.shouldRetry()) break;
                return retryContext.nextRetry(HystrixCommandInterceptor.getRetryCause(e));
            }
        }
        return HystrixCommandInterceptor.getCause(e);
    }

    private static Throwable getRetryCause(HystrixRuntimeException e) {
        if (e.getCause() instanceof Exception) {
            return e.getCause().getCause() instanceof Error ? e.getCause().getCause() : e.getCause();
        }
        return e;
    }

    private static Exception getCause(HystrixRuntimeException e) {
        return e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
    }

    private SynchronousCircuitBreaker getSynchronousCircuitBreaker(CommandMetadata metadata) {
        if (this.nonFallBackEnable.booleanValue() && this.syncCircuitBreakerEnabled.booleanValue() && metadata.hasCircuitBreaker()) {
            HystrixCircuitBreaker circuitBreaker = this.circuitBreakers.computeIfAbsent(metadata.commandKey.name(), key -> new SynchronousCircuitBreaker(metadata.operation.getCircuitBreaker()));
            if (circuitBreaker instanceof SynchronousCircuitBreaker) {
                return (SynchronousCircuitBreaker)circuitBreaker;
            }
            throw new IllegalStateException("Cached circuit breaker does not extend SynchronousCircuitBreaker");
        }
        return null;
    }

    private static IllegalStateException errorProcessingHystrixRuntimeException(HystrixRuntimeException e) {
        return new IllegalStateException("Error during processing hystrix runtime exception", e);
    }

    private HystrixCommand.Setter initSetter(HystrixCommandKey commandKey, Method method, FaultToleranceOperation operation) {
        HystrixCommandProperties.Setter propertiesSetter = HystrixCommandProperties.Setter();
        if (operation.isAsync() || operation.hasTimeout()) {
            propertiesSetter.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
        } else {
            propertiesSetter.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE);
        }
        if (this.nonFallBackEnable.booleanValue() && operation.hasTimeout()) {
            Long value = Duration.of((Long)operation.getTimeout().get("value"), (TemporalUnit)operation.getTimeout().get("unit")).toMillis();
            if (value > Integer.MAX_VALUE) {
                LOGGER.warnf("Max supported value for @Timeout.value() is %s", (Object)Integer.MAX_VALUE);
                value = Integer.MAX_VALUE;
            }
            propertiesSetter.withExecutionTimeoutInMilliseconds(value.intValue());
            propertiesSetter.withExecutionIsolationThreadInterruptOnTimeout(true);
        } else {
            propertiesSetter.withExecutionTimeoutEnabled(false);
        }
        if (this.nonFallBackEnable.booleanValue() && operation.hasCircuitBreaker()) {
            propertiesSetter.withCircuitBreakerEnabled(true).withCircuitBreakerRequestVolumeThreshold(((Integer)operation.getCircuitBreaker().get("requestVolumeThreshold")).intValue()).withCircuitBreakerErrorThresholdPercentage(new Double((Double)operation.getCircuitBreaker().get("failureRatio") * 100.0).intValue()).withCircuitBreakerSleepWindowInMilliseconds((int)Duration.of((Long)operation.getCircuitBreaker().get("delay"), (TemporalUnit)operation.getCircuitBreaker().get("delayUnit")).toMillis());
        } else {
            propertiesSetter.withCircuitBreakerEnabled(false);
        }
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"DefaultCommandGroup")).andCommandKey(commandKey).andCommandPropertiesDefaults(propertiesSetter);
        if (this.nonFallBackEnable.booleanValue() && operation.hasBulkhead()) {
            BulkheadConfig bulkhead = operation.getBulkhead();
            if (operation.isAsync()) {
                setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)commandKey.name()));
                HystrixThreadPoolProperties.Setter threadPoolSetter = HystrixThreadPoolProperties.Setter();
                threadPoolSetter.withAllowMaximumSizeToDivergeFromCoreSize(true);
                threadPoolSetter.withCoreSize(((Integer)bulkhead.get("value")).intValue());
                threadPoolSetter.withMaximumSize(((Integer)bulkhead.get("value")).intValue());
                threadPoolSetter.withMaxQueueSize(((Integer)bulkhead.get("waitingTaskQueue")).intValue());
                threadPoolSetter.withQueueSizeRejectionThreshold(((Integer)bulkhead.get("waitingTaskQueue")).intValue());
                setter.andThreadPoolPropertiesDefaults(threadPoolSetter);
            } else {
                propertiesSetter.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE);
                propertiesSetter.withExecutionIsolationSemaphoreMaxConcurrentRequests(((Integer)bulkhead.get("value")).intValue());
                propertiesSetter.withExecutionIsolationThreadInterruptOnFutureCancel(true);
            }
        }
        return setter;
    }

    private /* synthetic */ CommandMetadata lambda$interceptCommand$0(Class beanClass, Method method, Method k) {
        return new CommandMetadata(beanClass, method);
    }

    static class AsyncFuture
    implements Future<Object> {
        private final Future<Object> delegate;

        public AsyncFuture(Future<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            Future<Object> future;
            try {
                future = this.unwrapFuture(this.delegate.get());
            }
            catch (ExecutionException e) {
                throw this.unwrapExecutionException(e);
            }
            try {
                return this.logResult(future, future.get());
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.unableToUnwrap(future);
            }
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Future<Object> future;
            try {
                future = this.unwrapFuture(this.delegate.get());
            }
            catch (ExecutionException e) {
                throw this.unwrapExecutionException(e);
            }
            try {
                return this.logResult(future, future.get(timeout, unit));
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.unableToUnwrap(future);
            }
        }

        private Future<Object> unwrapFuture(Object futureObject) {
            if (futureObject instanceof Future) {
                return (Future)futureObject;
            }
            throw new IllegalStateException("A result of an @Asynchronous call must be Future: " + futureObject);
        }

        private ExecutionException unwrapExecutionException(ExecutionException e) throws ExecutionException {
            if (e.getCause() instanceof HystrixRuntimeException) {
                HystrixRuntimeException hystrixRuntimeException = (HystrixRuntimeException)e.getCause();
                Exception res = HystrixRuntimeException.FailureType.COMMAND_EXCEPTION.equals((Object)hystrixRuntimeException.getFailureType()) ? HystrixCommandInterceptor.getCause(hystrixRuntimeException) : HystrixCommandInterceptor.errorProcessingHystrixRuntimeException(hystrixRuntimeException);
                return new ExecutionException(res);
            }
            return e;
        }

        private IllegalStateException unableToUnwrap(Future<Object> future) {
            return new IllegalStateException("Unable to get the result of: " + future);
        }

        private Object logResult(Future<Object> future, Object unwrapped) {
            LOGGER.tracef("Unwrapped async result from %s: %s", future, unwrapped);
            return unwrapped;
        }
    }

    private class CommandMetadata {
        private final HystrixCommand.Setter setter;
        private final HystrixCommandKey commandKey;
        private final Method fallbackMethod;
        private final FaultToleranceOperation operation;

        CommandMetadata(Class<?> beanClass, Method method) {
            this.operation = HystrixCommandInterceptor.this.faultToleranceOperationProvider.get(beanClass, method);
            this.commandKey = HystrixCommandKey.Factory.asKey((String)SimpleCommand.getCommandKey(method));
            this.setter = HystrixCommandInterceptor.this.initSetter(this.commandKey, method, this.operation);
            if (this.operation.hasFallback()) {
                FallbackConfig fallbackConfig = this.operation.getFallback();
                if (!fallbackConfig.get("value").equals(Fallback.DEFAULT.class)) {
                    this.fallbackMethod = null;
                } else {
                    String fallbackMethodName = (String)fallbackConfig.get("fallbackMethod");
                    if (!"".equals(fallbackMethodName)) {
                        try {
                            this.fallbackMethod = SecurityActions.getDeclaredMethod(method.getDeclaringClass(), fallbackMethodName, method.getParameterTypes());
                            SecurityActions.setAccessible(this.fallbackMethod);
                        }
                        catch (NoSuchMethodException | PrivilegedActionException e) {
                            throw new FaultToleranceException("Could not obtain fallback method", (Throwable)e);
                        }
                    } else {
                        this.fallbackMethod = null;
                    }
                }
            } else {
                this.fallbackMethod = null;
            }
        }

        boolean hasCircuitBreaker() {
            return this.operation.hasCircuitBreaker();
        }

        Supplier<Object> getFallback(final ExecutionContextWithInvocationContext ctx) {
            Supplier<Object> fallback = null;
            if (this.fallbackMethod != null) {
                fallback = new Supplier<Object>(){

                    @Override
                    public Object get() {
                        try {
                            if (CommandMetadata.this.fallbackMethod.isDefault()) {
                                return DefaultMethodFallbackProvider.getFallback(CommandMetadata.this.fallbackMethod, ctx);
                            }
                            return CommandMetadata.this.fallbackMethod.invoke(ctx.getTarget(), ctx.getParameters());
                        }
                        catch (Throwable e) {
                            throw new FaultToleranceException("Error during fallback method invocation", e);
                        }
                    }
                };
            } else {
                final FallbackHandler fallbackHandler = HystrixCommandInterceptor.this.fallbackHandlerProvider.get(this.operation);
                if (fallbackHandler != null) {
                    fallback = new Supplier<Object>(){

                        @Override
                        public Object get() {
                            return fallbackHandler.handle((ExecutionContext)ctx);
                        }
                    };
                }
            }
            return fallback;
        }
    }
}

