/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import com.netflix.hystrix.HystrixCircuitBreaker;
import io.smallrye.faulttolerance.config.CircuitBreakerConfig;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.logging.Logger;

class SynchronousCircuitBreaker
implements HystrixCircuitBreaker {
    private static final Logger LOGGER = Logger.getLogger(SynchronousCircuitBreaker.class);
    private final AtomicReference<Status> status;
    private final AtomicLong circuitOpenedAt;
    private final CircuitBreakerConfig config;
    private final AtomicInteger successCount;
    private final AtomicInteger failureCount;
    private final AtomicInteger halfOpenAttempts;
    private final String id;

    SynchronousCircuitBreaker(CircuitBreakerConfig config) {
        this.config = config;
        this.status = new AtomicReference<Status>(Status.CLOSED);
        this.circuitOpenedAt = new AtomicLong(-1L);
        this.successCount = new AtomicInteger(0);
        this.failureCount = new AtomicInteger(0);
        this.halfOpenAttempts = new AtomicInteger(0);
        this.id = config.getMethodInfo();
    }

    public void markSuccess() {
    }

    public void markNonSuccess() {
    }

    public synchronized boolean isOpen() {
        return this.circuitOpenedAt.get() >= 0L;
    }

    public synchronized boolean allowRequest() {
        switch (this.status.get()) {
            case CLOSED: {
                return true;
            }
            case HALF_OPEN: {
                return this.isHalfOpenAttemptAllowed();
            }
            case OPEN: {
                return this.isAfterDelay();
            }
        }
        return false;
    }

    public synchronized boolean attemptExecution() {
        switch (this.status.get()) {
            case CLOSED: {
                return true;
            }
            case HALF_OPEN: {
                if (this.isHalfOpenAttemptAllowed()) {
                    this.halfOpenAttempts.incrementAndGet();
                    return true;
                }
                return false;
            }
            case OPEN: {
                if (this.isAfterDelay()) {
                    LOGGER.debugf("OPEN >> HALF_OPEN [id:%s]", (Object)this.id);
                    this.status.set(Status.HALF_OPEN);
                    this.halfOpenAttempts.set(1);
                    this.resetCounts();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    synchronized void executionSucceeded() {
        this.successCount.incrementAndGet();
        Status current = this.status.get();
        if (Status.HALF_OPEN == current && this.isSuccessThresholdReached()) {
            this.toClosed();
        } else if (Status.CLOSED == current && this.isFailureThresholdReached()) {
            this.toOpen(current);
        }
    }

    synchronized void executionFailed() {
        this.failureCount.incrementAndGet();
        Status current = this.status.get();
        if (Status.HALF_OPEN == current || Status.CLOSED == current && this.isFailureThresholdReached()) {
            this.toOpen(current);
        }
    }

    private void toClosed() {
        LOGGER.debugf("HALF_OPEN >> CLOSED [id:%s]", (Object)this.id);
        this.status.set(Status.CLOSED);
        this.circuitOpenedAt.set(-1L);
        this.resetCounts();
    }

    private void toOpen(Status current) {
        LOGGER.debugf("%s >> OPEN [id:%s]", (Object)current, (Object)this.id);
        this.status.set(Status.OPEN);
        this.circuitOpenedAt.set(System.currentTimeMillis());
        this.resetCounts();
    }

    private boolean isAfterDelay() {
        long elapsed;
        long openedAt = this.circuitOpenedAt.get();
        long delay = (Long)this.config.get("delay");
        if (delay == 0L) {
            return true;
        }
        ChronoUnit delayUnit = (ChronoUnit)this.config.get("delayUnit");
        if (delayUnit.equals(ChronoUnit.MILLIS)) {
            elapsed = System.currentTimeMillis() - openedAt;
        } else {
            Instant start = Instant.ofEpochMilli(openedAt);
            Instant now = Instant.now();
            elapsed = delayUnit.between(start, now);
        }
        return elapsed >= delay;
    }

    private boolean isFailureThresholdReached() {
        double failureRatio;
        int requestVolumeThreshold;
        int requestCount = this.getRequestCount();
        if (requestCount < (requestVolumeThreshold = ((Integer)this.config.get("requestVolumeThreshold")).intValue())) {
            return false;
        }
        double failureCheck = (double)this.failureCount.get() / (double)requestCount;
        return failureCheck >= (failureRatio = ((Double)this.config.get("failureRatio")).doubleValue()) || failureRatio <= 0.0 && failureCheck == 1.0;
    }

    private boolean isSuccessThresholdReached() {
        return this.successCount.get() >= this.config.get("successThreshold", Integer.class);
    }

    private boolean isHalfOpenAttemptAllowed() {
        return this.halfOpenAttempts.get() < this.config.get("successThreshold", Integer.class);
    }

    private int getRequestCount() {
        return this.successCount.get() + this.failureCount.get();
    }

    private void resetCounts() {
        this.successCount.set(0);
        this.failureCount.set(0);
    }

    static enum Status {
        CLOSED,
        OPEN,
        HALF_OPEN;

    }
}

