/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import io.smallrye.faulttolerance.BasicCommand;
import io.smallrye.faulttolerance.ExecutionContextWithInvocationContext;
import io.smallrye.faulttolerance.MetricNames;
import io.smallrye.faulttolerance.MetricsCollectorFactory;
import io.smallrye.faulttolerance.SimpleCommand;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

public class CompositeCommand
extends BasicCommand {
    private final Callable<Object> callable;
    private final ExecutionContextWithInvocationContext ctx;
    private final FaultToleranceOperation operation;
    private final MetricRegistry registry;
    private final long queuedAt;

    public static Future<Object> createAndQueue(Callable<Object> callable, FaultToleranceOperation operation, ExecutionContextWithInvocationContext ctx, MetricRegistry registry) {
        return new CompositeCommand(callable, operation, ctx, registry).queue();
    }

    @Override
    void setFailure(Throwable f) {
        this.ctx.setFailure(f);
    }

    @Override
    FaultToleranceOperation getOperation() {
        return this.operation;
    }

    protected CompositeCommand(Callable<Object> callable, FaultToleranceOperation operation, ExecutionContextWithInvocationContext ctx, MetricRegistry registry) {
        super(CompositeCommand.initSetter(operation));
        this.operation = operation;
        this.callable = callable;
        this.ctx = ctx;
        this.registry = registry;
        this.queuedAt = System.nanoTime();
    }

    protected Object run() throws Exception {
        if (this.registry != null && this.operation.hasBulkhead()) {
            this.histogramOf(MetricNames.metricsPrefix(this.operation.getMethod()) + ".bulkhead.waiting.duration").update(System.nanoTime() - this.queuedAt);
        }
        return this.callable.call();
    }

    private static HystrixCommand.Setter initSetter(FaultToleranceOperation operation) {
        HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter();
        HystrixCommandKey commandKey = HystrixCommandKey.Factory.asKey((String)(CompositeCommand.class.getSimpleName() + "#" + SimpleCommand.getCommandKey(operation.getMethod())));
        properties.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
        properties.withFallbackEnabled(false);
        properties.withCircuitBreakerEnabled(false);
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"CompositeCommandGroup")).andCommandKey(commandKey).andCommandPropertiesDefaults(properties);
        setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)commandKey.name()));
        HystrixThreadPoolProperties.Setter threadPoolSetter = HystrixThreadPoolProperties.Setter();
        threadPoolSetter.withAllowMaximumSizeToDivergeFromCoreSize(true);
        setter.andThreadPoolPropertiesDefaults(threadPoolSetter);
        return setter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Histogram histogramOf(String name) {
        Histogram histogram = (Histogram)this.registry.getHistograms().get(name);
        if (histogram == null) {
            FaultToleranceOperation faultToleranceOperation = this.operation;
            synchronized (faultToleranceOperation) {
                histogram = (Histogram)this.registry.getHistograms().get(name);
                if (histogram == null) {
                    histogram = this.registry.histogram(MetricsCollectorFactory.metadataOf(name, MetricType.HISTOGRAM));
                }
            }
        }
        return histogram;
    }
}

