/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.config.RetryConfig;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

class RetryContext {
    private final RetryConfig config;
    private final AtomicInteger remainingAttempts;
    private final AtomicReference<Boolean> shouldRetry = new AtomicReference();
    private final long start;
    private final long maxDuration;
    private final long delay;

    RetryContext(RetryConfig config) {
        this.config = config;
        this.start = System.nanoTime();
        this.remainingAttempts = new AtomicInteger((Integer)config.get("maxRetries"));
        this.maxDuration = Duration.of((Long)config.get("maxDuration"), (TemporalUnit)config.get("durationUnit")).toNanos();
        this.delay = Duration.of((Long)config.get("delay"), (TemporalUnit)config.get("delayUnit")).toMillis();
    }

    RetryConfig getConfig() {
        return this.config;
    }

    Exception nextRetry(Throwable throwable) {
        if (this.shouldRetryOn(throwable)) {
            this.shouldRetry.set(null);
            this.remainingAttempts.decrementAndGet();
            return this.delayIfNeeded();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return new FaultToleranceException(throwable);
    }

    boolean shouldRetry() {
        return this.remainingAttempts.get() > 0;
    }

    boolean isLastAttempt() {
        return this.remainingAttempts.get() == 1;
    }

    boolean shouldRetryOn(Throwable exception) {
        Boolean retry = this.shouldRetry.get();
        if (retry == null) {
            retry = this.shouldRetry() && (this.config.getAbortOn().length == 0 || Arrays.stream(this.config.getAbortOn()).noneMatch(ex -> ex.isAssignableFrom(exception.getClass()))) && this.retryOn(exception) && System.nanoTime() - this.start <= this.maxDuration;
            retry = this.shouldRetry.compareAndSet(null, retry) ? retry : this.shouldRetry.get();
        }
        return retry;
    }

    private boolean retryOn(Throwable throwable) {
        Class<?>[] retryOn = this.config.getRetryOn();
        if (retryOn.length == 0) {
            return false;
        }
        if (retryOn.length == 1) {
            Class<?> exceptionClass = retryOn[0];
            return throwable == null || exceptionClass.isAssignableFrom(throwable.getClass());
        }
        return Arrays.stream(retryOn).anyMatch(t -> t.isAssignableFrom(throwable.getClass()));
    }

    Exception delayIfNeeded() {
        if (this.delay > 0L) {
            long jitterBase = this.config.getJitter();
            long jitter = (long)(Math.random() * (double)(jitterBase * 2L + 1L)) - jitterBase;
            try {
                TimeUnit.MILLISECONDS.sleep(this.delay + Duration.of(jitter, this.config.getJitterDelayUnit()).toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return e;
            }
        }
        return null;
    }

    public String toString() {
        return "RetryContext [remainingAttempts=" + this.remainingAttempts + ", start=" + this.start + "]";
    }

    boolean hasBeenRetried() {
        return this.remainingAttempts.get() < (Integer)this.config.get("maxRetries");
    }
}

