/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import io.smallrye.faulttolerance.BasicCommand;
import io.smallrye.faulttolerance.ExecutionContextWithInvocationContext;
import io.smallrye.faulttolerance.RetryContext;
import io.smallrye.faulttolerance.SimpleCommand;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.metrics.MetricNames;
import io.smallrye.faulttolerance.metrics.MetricsCollectorFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

public class CompositeCommand
extends BasicCommand {
    private final Callable<Object> callable;
    private final ExecutionContextWithInvocationContext ctx;
    private final FaultToleranceOperation operation;
    private final RetryContext retryContext;
    private final MetricRegistry registry;

    public static Future<Object> createAndQueue(Callable<Object> callable, FaultToleranceOperation operation, RetryContext retryContext, ExecutionContextWithInvocationContext ctx, MetricRegistry registry, boolean timeoutEnabled) {
        return new CompositeCommand(callable, operation, retryContext, ctx, registry, timeoutEnabled).queue();
    }

    @Override
    void setFailure(Throwable f) {
        this.ctx.setFailure(f);
    }

    @Override
    FaultToleranceOperation getOperation() {
        return this.operation;
    }

    protected CompositeCommand(Callable<Object> callable, FaultToleranceOperation operation, RetryContext retryContext, ExecutionContextWithInvocationContext ctx, MetricRegistry registry, boolean timeoutEnabled) {
        super(CompositeCommand.initSetter(operation, timeoutEnabled));
        this.operation = operation;
        this.callable = callable;
        this.retryContext = retryContext;
        this.ctx = ctx;
        this.registry = registry;
    }

    protected Object run() throws Exception {
        String metricsPrefix = MetricNames.metricsPrefix(this.operation.getMethod());
        if (this.retryContext == null) {
            return this.callable.call();
        }
        while (true) {
            try {
                if (this.registry != null && this.retryContext.hasBeenRetried()) {
                    this.counterOf(metricsPrefix + ".retry.retries.total").inc();
                }
                Object result = this.callable.call();
                if (this.registry != null) {
                    if (this.retryContext.hasBeenRetried()) {
                        this.counterOf(metricsPrefix + ".retry.callsSucceededRetried.total").inc();
                    } else {
                        this.counterOf(metricsPrefix + ".retry.callsSucceededNotRetried.total").inc();
                    }
                }
                return result;
            }
            catch (Throwable e) {
                if (this.retryContext.shouldRetry()) {
                    Exception shouldRetry;
                    if ((shouldRetry = this.retryContext.nextRetry(e)) == null) continue;
                    throw shouldRetry;
                }
                if (this.registry != null) {
                    this.counterOf(metricsPrefix + ".retry.callsFailed.total").inc();
                }
                throw e;
            }
            break;
        }
    }

    private static HystrixCommand.Setter initSetter(FaultToleranceOperation operation, boolean timeoutEnabled) {
        HystrixCommandKey commandKey = CompositeCommand.hystrixCommandKey(operation);
        return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)CompositeCommand.hystrixCommandGroupKey()).andCommandKey(commandKey).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).withFallbackEnabled(false).withCircuitBreakerEnabled(false).withExecutionTimeoutEnabled(timeoutEnabled)).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)commandKey.name())).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withAllowMaximumSizeToDivergeFromCoreSize(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Counter counterOf(String name) {
        Counter counter = (Counter)this.registry.getCounters().get(name);
        if (counter == null) {
            FaultToleranceOperation faultToleranceOperation = this.operation;
            synchronized (faultToleranceOperation) {
                counter = (Counter)this.registry.getCounters().get(name);
                if (counter == null) {
                    counter = this.registry.counter(MetricsCollectorFactory.metadataOf(name, MetricType.COUNTER));
                }
            }
        }
        return counter;
    }

    static HystrixCommandGroupKey hystrixCommandGroupKey() {
        return HystrixCommandGroupKey.Factory.asKey((String)"CompositeCommandGroup");
    }

    static HystrixCommandKey hystrixCommandKey(FaultToleranceOperation operation) {
        return HystrixCommandKey.Factory.asKey((String)(CompositeCommand.class.getSimpleName() + "#" + SimpleCommand.getCommandKey(operation.getMethod())));
    }
}

